% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netplot.r
\name{nplot}
\alias{nplot}
\alias{netplot}
\alias{nplot.igraph}
\alias{nplot.network}
\alias{nplot.default}
\alias{print.netplot}
\title{Plot a network}
\usage{
nplot(...)

\method{nplot}{igraph}(
  x,
  layout = igraph::layout_nicely(x),
  vertex.size = igraph::degree(x, mode = "in"),
  vertex.label = igraph::vertex_attr(x, "name"),
  edge.width = igraph::edge_attr(x, "weight"),
  ...
)

\method{nplot}{network}(
  x,
  layout = sna::gplot.layout.kamadakawai(x, NULL),
  vertex.size = sna::degree(x, cmode = "indegree"),
  vertex.label = network::get.vertex.attribute(x, "vertex.names"),
  ...
)

\method{nplot}{default}(
  edgelist,
  layout,
  vertex.size = 1,
  bg.col = "transparent",
  vertex.nsides = 15,
  vertex.color = grDevices::hcl.colors(1),
  vertex.size.range = c(0.01, 0.03),
  vertex.frame.color = grDevices::adjustcolor(vertex.color, red.f = 0.75, green.f =
    0.75, blue.f = 0.75),
  vertex.rot = 0,
  vertex.frame.prop = 0.2,
  vertex.label = NULL,
  vertex.label.fontsize = NULL,
  vertex.label.color = "black",
  vertex.label.fontfamily = "HersheySans",
  vertex.label.fontface = "bold",
  vertex.label.show = 0.3,
  vertex.label.range = c(5, 15),
  edge.width = 1,
  edge.width.range = c(1, 2),
  edge.arrow.size = NULL,
  edge.color = ~ego(alpha = 0.25) + alter,
  edge.curvature = pi/3,
  edge.line.lty = "solid",
  edge.line.breaks = 10,
  sample.edges = 1,
  skip.vertex = FALSE,
  skip.edges = FALSE,
  skip.arrows = skip.edges,
  add = FALSE,
  zero.margins = TRUE,
  ...
)

\method{print}{netplot}(x, y = NULL, newpage = TRUE, ...)
}
\arguments{
\item{x}{An \code{igraph} object.}

\item{layout}{Numeric two-column matrix with the graph layout.}

\item{vertex.size}{Numeric vector of length \code{vcount(x)}. Absolute size of the vertex.}

\item{vertex.label}{Character vector of length \code{vcount(x)}. Labels.}

\item{edge.width}{Vector of length \code{ecount(x)}.}

\item{edgelist}{An edgelist.}

\item{bg.col}{Color of the background.}

\item{vertex.nsides}{Numeric vector of length \code{vcount(x)}. Number of sizes of
the vertex. E.g. three is a triangle, and 100 approximates a circle.}

\item{vertex.color}{Vector of length \code{vcount(x)}. Vertex colors.}

\item{vertex.size.range}{Vector of length \code{vcount(x)}.}

\item{vertex.frame.color}{Vector of length \code{vcount(x)}.}

\item{vertex.rot}{Vector of length \code{vcount(x)}. Passed to \link{npolygon},
elevation degree from which the polygon is drawn.}

\item{vertex.frame.prop}{Vector of length \code{vcount(x)}. What proportion of the
vertex does the frame occupy (values between 0 and 1).}

\item{vertex.label.fontsize}{Numeric vector.}

\item{vertex.label.color}{Vector of colors of length \code{vcount(x)}.}

\item{vertex.label.fontfamily}{Character vector of length \code{vcount(x)}.}

\item{vertex.label.fontface}{See \link[grid:gpar]{grid::gpar}}

\item{vertex.label.show}{Numeric scalar. Proportion of labels to show as the
top ranking according to \code{vertex.size}.}

\item{vertex.label.range}{Numeric vector of size 2 or 3. Relative scale of
\code{vertex.label.fontsize} in points (see \link[grid:gpar]{grid::gpar}).}

\item{edge.width.range}{Vector of length \code{ecount(x)}.}

\item{edge.arrow.size}{Vector of length \code{ecount(x)}.}

\item{edge.color}{A vector of length \code{ecount(x)}. Can be \code{NULL} in which case
the color is picked as a mixture between ego and alters' \code{vertex.color} values.}

\item{edge.curvature}{Numeric vector of length \code{ecount(x)}. Curvature of edges
in terms of radians.}

\item{edge.line.lty}{Vector of length \code{ecount(x)}.}

\item{edge.line.breaks}{Vector of length \code{ecount(x)}. Number of vertices to
draw (approximate) the arc (edge).}

\item{sample.edges}{Numeric scalar between 0 and 1. Proportion of edges to sample.}

\item{skip.vertex, skip.edges, skip.arrows}{Logical scalar. When \code{TRUE} the object
is not plotted.}

\item{add}{Logical scalar.}

\item{zero.margins}{Logical scalar.}

\item{y, ...}{Ignored}

\item{newpage}{Logical scalar. When \code{TRUE} calls \link[grid:grid.newpage]{grid::grid.newpage}.}
}
\value{
An object of class \code{c("netplot", "gTree", "grob", "gDesc")}. The object
has an additional set of attributes:
\itemize{
\item \verb{.xlim, .ylim} vector of size two with the x-asis/y-axis limits.
\item \code{.layout} A numeric matrix of size \code{vcount(x) * 2} with the vertices positions
\item \code{.edgelist} A numeric matrix, The edgelist.
}

In the case of \code{nplot.default}, an object of class \code{netplot} and \code{grob} (see
\link[grid:grid.grob]{grid::grob}) with the following slots:
\itemize{
\item \code{children} The main \code{grob} of the object.
\item \code{name} Character scalar. The name of the plot
\item \code{.xlim} and \code{.ylim} Two vectors indicating the limits of the plot
\item \code{.layout} A two-column matrix with the location of the vertices.
\item \code{.edgelist} A two-column matrix, an edgelist.
\item \code{.N} Integer. The number of vertices.
\item \code{.M} Integer. The number of edges.
}

The \code{children} \code{grob} contains the following two objects:
\itemize{
\item \code{background} a \code{grob} rectangule.
\item \code{graph} a \code{gTree} that contains each vertex and each edge
of the figure.
}
}
\description{
Plot a network
}
\details{
In the case of \code{edge.color}, the user can specify colors using \link{netplot-formulae}.
}
\examples{
library(igraph)
library(netplot)
set.seed(1)
x <- sample_smallworld(1, 200, 5, 0.03)

plot(x) # ala igraph
nplot(x) # ala netplot
}
\seealso{
\link{nplot_base}
}
