% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nestfs.R
\name{nested.glm}
\alias{nested.glm}
\title{Cross-validated generalized linear models}
\usage{
nested.glm(x, y, model, family, folds, store.glm = FALSE)
}
\arguments{
\item{x}{Dataframe of predictors.}

\item{y}{Outcome variable. If \code{family=binomial}, it can only contain
two classes of values that can be coerced to 0-1.}

\item{model}{Either a formula or a vector of names for the set of variables
that define the model to be fitted.}

\item{family}{Type of model fitted: either \code{gaussian()} for linear
regression or \code{binomial()} for logistic regression. This can be
specified also as a function name (\code{gaussian}) or as a string
(\code{"gaussian"}).}

\item{folds}{List of cross-validation folds, where each element contains
the indices of the observations to be withdrawn in that fold.}

\item{store.glm}{Whether the object produced by \code{glm} should be
stored (default: \code{FALSE}).}
}
\value{
An object of class \code{nestglm} of length equal to \code{length(folds)},
where each entry contains the following fields:
\describe{
\item{summary:}{Summary of the coefficients of the model fitted on the
      training observations.}
\item{family:}{Type of model fitted.}
\item{fit:}{Predicted values for the withdrawn observations.}
\item{obs:}{Observed values for the withdrawn observations.}
\item{test.llk:}{Test log-likelihood.}
\item{test.idx:}{Indices of the the withdrawn observations for this fold.}
\item{regr:}{Object created by glm (only if \code{store.glm=TRUE}).}
}
}
\description{
Run linear or logistic regression on a set of cross-validation folds.
}
\details{
This can be used to establish a baseline model, often built only on the
initial set of covariates (those that would be passed through the
\code{init.model} argument to \code{forward.selection}).
}
\examples{
# register a parallel cluster with two cores
library(doParallel)
registerDoParallel(2)

data(diabetes)
folds <- create.folds(10, nrow(X.diab), seed=1)
base.res <- nested.glm(X.diab, Y.diab, c("age", "sex", "bmi", "map"),
                       gaussian(), folds)

# close the parallel cluster
stopImplicitCluster()

}
\seealso{
\code{\link{nested.performance}}.
}
\keyword{multivariate}
