% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neon_download.R
\name{neon_download}
\alias{neon_download}
\title{Download NEON data products into a local store}
\usage{
neon_download(
  product,
  start_date = NA,
  end_date = NA,
  site = NA,
  type = "expanded",
  file_regex = "[.]zip",
  quiet = FALSE,
  verify = TRUE,
  dir = neon_dir(),
  unzip = TRUE,
  api = "https://data.neonscience.org/api/v0",
  .token = Sys.getenv("NEON_TOKEN")
)
}
\arguments{
\item{product}{A NEON \code{productCode}. See \link{neon_download}.}

\item{start_date}{Download only files as recent as (\code{YYYY-MM-DD}). Leave
as \code{NA} to download up to the most recent available data.}

\item{end_date}{Download only files up to end_date (\code{YYYY-MM-DD}). Leave as
\code{NA} to download all prior data.}

\item{site}{4-letter site code(s) to filter on. Leave as \code{NA} to search all.}

\item{type}{Should we prefer the basic or expanded version of this product?
See details.}

\item{file_regex}{Download only files matching this pattern.  See details.}

\item{quiet}{Should download progress be displayed?}

\item{verify}{Should downloaded files be compared against the MD5 hash
reported by the NEON API to verify integrity? (default \code{TRUE})}

\item{dir}{Location where files should be downloaded. By default will
use the appropriate applications directory for your system
(see \link[rappdirs:user_data_dir]{rappdirs::user_data_dir}).  This default also be configured by
setting the environmental variable \code{NEONSTORE_HOME}, see \link{Sys.setenv} or
\link{Renviron}.}

\item{unzip}{should we extract .zip files? (default \code{TRUE}). Note: .zip
files are preserved in the store to avoid repeated downloads.}

\item{api}{the URL to the NEON API, leave as default.}

\item{.token}{an authentication token from NEON. A token is not
required but will allow access to a higher number of requests before
rate limiting applies, see
\url{https://data.neonscience.org/data-api/rate-limiting/#api-tokens}.
Note that once files are downloaded once, \code{neonstore} provides persistent
access to them without further interaction required with the API.}
}
\description{
Download NEON data products into a local store
}
\details{
Each NEON data product consists of a collection of
objects (e.g. tables), which are in turn broken into individual files by
site and sampling month.  Additionally, many NEON products have been
expanded, including some additional columns. Consequently, users must
specify if they want the "basic" or "expanded" version of this data.

In the products table (see \link{neon_products}), the \code{productHasExpanded}
column indicates if the data
product has expanded, and the columns \code{productHasBasicDescription} and
\code{productHasExpandedDescription} provide a detailed explanation of the
differences between the \code{"expanded"} and \code{"basic"} versions of that
particular product.

The API provides access to a \code{.zip} file containing all the component objects
(e.g. tables) for that product at that site and sampling month. Additionally,
the API allows users to request component files directly (e.g. as \code{.csv}
files).  Requesting component files directly avoids the additional overhead
of downloading other components that are not needed.  Both the \code{.zip} and
relevant \code{.csv} and \code{zip} files in products that have expanded will include
both a \code{"basic"} and \code{"expanded"} name in the filename.  Setting \code{type}
argument of \code{neon_download()} to the preferred one will make it filter out
the other one.

By default, \code{neon_download()} will request the \code{.zip} packet for the product,
matching the requested type.  \code{neon_download()} will extract the component
files into the store, removing the \code{.zip} file.  Specific files within a
product can be identified by altering the \code{file_regex} argument
(see examples).

\code{neon_download()} will avoid downloading metadata files which are bitwise
identical to other files in the same download request, as indicated by the
crc32 hash reported by the API.  These typically include metadata that are
shared across the product as a whole, but are for some reason included in
each sampling month for each site -- potentially thousands of duplicates.
These duplicates are also packaged within the \code{.zip} downloads where it
is not possible to exclude them from the download.
}
\examples{
\donttest{
 
 neon_download("DP1.10003.001", 
               start_date = "2018-01-01", 
               end_date = "2019-01-01",
               site = "YELL")
               
 ## Advanced use: filter for a particular table in the product
 neon_download(product = "DP1.10003.001",
               start_date = "2018-01-01",
               end_date = "2019-01-01",
               site = "YELL",
               file_regex = ".*brd_countdata.*\\\\.csv")

}
}
