% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{brd_perpoint}
\alias{brd_perpoint}
\title{Per-point data table from Breeding landbird point counts (DP1.10003.001)}
\format{
A data frame with 54 rows and 31 columns
\describe{
  \item{uid}{Unique ID within NEON database; an identifier for the record}
  \item{namedLocation}{Name of the measurement location in the NEON database}
  \item{domainID}{Unique identifier of the NEON domain}
  \item{siteID}{NEON site code}
  \item{plotID}{Plot identifier (NEON site code_XXX)}
  \item{plotType}{NEON plot type in which sampling occurred: tower, distributed or gradient}
  \item{pointID}{Identifier for a point location}
  \item{nlcdClass}{National Land Cover Database Vegetation Type Name}
  \item{decimalLatitude}{The geographic latitude (in decimal degrees, WGS84) of the geographic center of the reference area}
  \item{decimalLongitude}{The geographic longitude (in decimal degrees, WGS84) of the geographic center of the reference area}
  \item{geodeticDatum}{Model used to measure horizontal position on the earth}
  \item{coordinateUncertainty}{The horizontal distance (in meters) from the given decimalLatitude and decimalLongitude describing the smallest circle containing the whole of the Location. Zero is not a valid value for this term}
  \item{elevation}{Elevation (in meters) above sea level}
  \item{elevationUncertainty}{Uncertainty in elevation values (in meters)}
  \item{startDate}{The start date-time or interval during which an event occurred}
  \item{samplingImpracticalRemarks}{Technician notes; free text comments accompanying the sampling impractical record}
  \item{samplingImpractical}{Samples and/or measurements were not collected due to the indicated circumstance}
  \item{eventID}{An identifier for the set of information associated with the event, which includes information about the place and time of the event}
  \item{startCloudCoverPercentage}{Observer estimate of percent cloud cover at start of sampling}
  \item{endCloudCoverPercentage}{Observer estimate of percent cloud cover at end of sampling}
  \item{startRH}{Relative humidity as measured by handheld weather meter at the start of sampling}
  \item{endRH}{Relative humidity as measured by handheld weather meter at the end of sampling}
  \item{observedHabitat}{Observer assessment of dominant habitat at the sampling point at sampling time}
  \item{observedAirTemp}{The air temperature measured with a handheld weather meter}
  \item{kmPerHourObservedWindSpeed}{The average wind speed measured with a handheld weather meter, in kilometers per hour}
  \item{laboratoryName}{Name of the laboratory or facility that is processing the sample}
  \item{samplingProtocolVersion}{The NEON document number and version where detailed information regarding the sampling method used is available; format NEON.DOC.######vX}
  \item{remarks}{Technician notes; free text comments accompanying the record}
  \item{measuredBy}{An identifier for the technician who measured or collected the data}
  \item{publicationDate}{Date of data publication on the NEON data portal}
  \item{release}{Identifier for data release}
}
}
\source{
\url{https://data.neonscience.org/api/v0/products/DP1.10003.001}
}
\usage{
brd_perpoint
}
\description{
An example set of NEON observational data. Contains the point metadata associated with bird observations from Niwot Ridge (NIWO) in 2019, as published in RELEASE-2021.
}
\keyword{datasets}
