% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trauma_04.R
\name{trauma_04}
\alias{trauma_04}
\title{Trauma-04 Calculations}
\usage{
trauma_04(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  situation_table = NULL,
  vitals_table = NULL,
  exam_table = NULL,
  procedures_table = NULL,
  injury_table = NULL,
  disposition_table = NULL,
  erecord_01_col,
  incident_date_col = NULL,
  patient_DOB_col = NULL,
  epatient_15_col,
  epatient_16_col,
  esituation_02_col,
  eresponse_05_col,
  eresponse_10_col,
  transport_disposition_col,
  edisposition_23_col,
  evitals_06_col,
  evitals_10_col,
  evitals_12_col,
  evitals_14_col,
  evitals_15_col,
  evitals_21_col,
  eexam_16_col,
  eexam_20_col,
  eexam_23_col,
  eexam_25_col,
  eprocedures_03_col,
  einjury_01_col,
  einjury_03_col,
  einjury_04_col,
  einjury_09_col,
  ...
)
}
\arguments{
\item{df}{A data frame or tibble containing EMS data with all relevant
columns.}

\item{patient_scene_table}{A data.frame or tibble containing only epatient
and escene fields as a fact table.}

\item{response_table}{A data.frame or tibble containing only the eresponse
fields needed for this measure's calculations.}

\item{situation_table}{A data.frame or tibble containing only the esituation
fields needed for this measure's calculations.}

\item{vitals_table}{A data.frame or tibble containing only the evitals fields
needed for this measure's calculations.}

\item{exam_table}{A data.frame or tibble containing only the eexam fields
needed for this measure's calculations.}

\item{procedures_table}{A data.frame or tibble containing only the
eprocedures fields needed for this measure's calculations.}

\item{injury_table}{A data.frame or tibble containing only the einjury fields
needed for this measure's calculations.}

\item{disposition_table}{A data.frame or tibble containing only the
edisposition fields needed for this measure's calculations.}

\item{erecord_01_col}{The column representing the EMS record unique
identifier.}

\item{incident_date_col}{Column that contains the incident date. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{patient_DOB_col}{Column that contains the patient's date of birth. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{epatient_15_col}{The column for patient age numeric value.}

\item{epatient_16_col}{The column for patient age unit (e.g., "Years",
"Months").}

\item{esituation_02_col}{The column containing information on the presence of
injury.}

\item{eresponse_05_col}{The column representing the 911 response type.}

\item{eresponse_10_col}{Column name containing scene delay information.}

\item{transport_disposition_col}{The column for patient transport
disposition.}

\item{edisposition_23_col}{Column name containing trauma hospital
verification information.}

\item{evitals_06_col}{Column name containing systolic blood pressure (SBP)
values.}

\item{evitals_10_col}{Column name containing heart rate values.}

\item{evitals_12_col}{Column name containing pulse oximetry values.}

\item{evitals_14_col}{Column name containing capillary refill information.}

\item{evitals_15_col}{Column name containing respiratory effort values.}

\item{evitals_21_col}{Column name containing Glasgow Coma Scale (GCS) Motor
values.}

\item{eexam_16_col}{Column name containing extremities assessment details.}

\item{eexam_20_col}{Column name containing neurological assessment details.}

\item{eexam_23_col}{Column name containing lung assessment details.}

\item{eexam_25_col}{Column name containing chest assessment details.}

\item{eprocedures_03_col}{Column name containing airway management or
tourniquet usage details.}

\item{einjury_01_col}{Column name containing injury cause details.}

\item{einjury_03_col}{Column name containing trauma triage steps 1 and 2
information.}

\item{einjury_04_col}{Column name containing trauma triage steps 3 and 4
information.}

\item{einjury_09_col}{Column name containing fall height information.}

\item{...}{Additional arguments passed to helper functions for further
customization.}
}
\value{
A tibble summarizing results for three age groups (< 10 yrs, 10–65
yrs, and >= 65 yrs) with the following columns:

\code{measure}: The name of the measure being calculated.
\code{pop}: Population type (< 10 yrs, 10–65 yrs, >= 65 yrs).
\code{numerator}: Count of incidents where the trauma hospital was a verified
trauma center levels 1 through 5.
\code{denominator}: Total count of incidents.
\code{prop}: Proportion of incidents where the trauma hospital was a verified
trauma center levels 1 through 5.
\code{prop_label}: Proportion formatted as a percentage with a specified number
of decimal places.
}
\description{
This function processes EMS data to generate a set of binary variables
indicating whether specific trauma triage criteria are met. The output is a
data frame enriched with these indicators for further analysis.  The final
outcome is whether or not the EMS record documents the use of a verified
trauma center levels 1-5 in the hospital capability documentation.
}
\examples{
# Synthetic test data
  test_data <- tibble::tibble(
    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    epatient_15 = c(34, 5, 45, 2, 60),  # Ages
    epatient_16 = c("Years", "Years", "Years", "Months", "Years"),
    eresponse_05 = rep(2205001, 5),
    eresponse_10 = rep(2210011, 5),
    esituation_02 = rep("Yes", 5),
    evitals_06 = c(100, 90, 80, 70, 85),
    evitals_10 = c(110, 89, 88, 71, 85),
    evitals_12 = c(50, 60, 70, 80, 75),
    evitals_14 = c(30, 9, 8, 7, 31),
    evitals_15 = c("apneic", "labored", "rapid", "shallow", "weak/agonal"),
    evitals_21 = c(5, 4, 3, 2, 1),
    eexam_16 = c(3516043, 3516067, 3516043, 3516067, 3516067),
    eexam_20 = c(3520045, 3520043, 3520019, 3520017, 3520017),
    eexam_23 = c(3523011, 3523003, 3523001, 3523011, 3523003),
    eexam_25 = c(3525039, 3525023, 3525005, 3525039, 3525023),
    edisposition_23 = c(9908029, 9908027, 9908025, 9908023, 9908021),
    edisposition_30 = c(4230001, 4230003, 4230001, 4230007, 4230007),
    eprocedures_03 = c(424979004, 427753009, 429705000, 47545007, 243142003),
    einjury_01 = c("V20", "V36", "V86", "V39", "V32"),
    einjury_03 = c(2903011, 2903009, 2903005, 3903003, 2903001),
    einjury_04 = c(2904013, 2904011, 2904009, 2904007, 2904001),
    einjury_09 = c(11, 12, 13, 14, 15)
  )

  # Run function with the first and last pain score columns
  trauma_04(
    df = test_data,
    erecord_01_col = erecord_01,
    epatient_15_col = epatient_15,
    epatient_16_col = epatient_16,
    eresponse_05_col = eresponse_05,
    eresponse_10_col = eresponse_10,
    esituation_02_col = esituation_02,
    evitals_06_col = evitals_06,
    evitals_10_col = evitals_10,
    evitals_12_col = evitals_12,
    evitals_14_col = evitals_14,
    evitals_15_col = evitals_15,
    evitals_21_col = evitals_21,
    eexam_16_col = eexam_16,
    eexam_20_col = eexam_20,
    eexam_23_col = eexam_23,
    eexam_25_col = eexam_25,
    edisposition_23_col = edisposition_23,
    transport_disposition_col = edisposition_30,
    eprocedures_03_col = eprocedures_03,
    einjury_01_col = einjury_01,
    einjury_03_col = einjury_03,
    einjury_04_col = einjury_04,
    einjury_09_col = einjury_09
  )


}
\author{
Nicolas Foss, Ed.D., MS
}
