% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypoglycemia_01.R
\name{hypoglycemia_01}
\alias{hypoglycemia_01}
\title{Hypoglycemia-01}
\usage{
hypoglycemia_01(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  situation_table = NULL,
  vitals_table = NULL,
  medications_table = NULL,
  procedures_table = NULL,
  erecord_01_col,
  incident_date_col = NULL,
  patient_DOB_col = NULL,
  epatient_15_col,
  epatient_16_col,
  eresponse_05_col,
  esituation_11_col,
  esituation_12_col,
  evitals_18_col,
  evitals_23_col,
  evitals_26_col,
  emedications_03_col,
  eprocedures_03_col,
  ...
)
}
\arguments{
\item{df}{A data frame or tibble containing emergency response records.
Default is \code{NULL}.}

\item{patient_scene_table}{A data.frame or tibble containing at least
ePatient and eScene fields as a fact table. Default is \code{NULL}.}

\item{response_table}{A data.frame or tibble containing at least the
eResponse fields needed for this measure's calculations. Default is \code{NULL}.}

\item{situation_table}{A data.frame or tibble containing at least the
eSituation fields needed for this measure's calculations. Default is
\code{NULL}.}

\item{vitals_table}{A data.frame or tibble containing at least the eVitals
fields needed for this measure's calculations. Default is \code{NULL}.}

\item{medications_table}{A data.frame or tibble containing at least the
eMedications fields needed for this measure's calculations. Default is
\code{NULL}.}

\item{procedures_table}{A data.frame or tibble containing at least the
eProcedures fields needed for this measure's calculations. Default is
\code{NULL}.}

\item{erecord_01_col}{Column representing the unique record identifier.}

\item{incident_date_col}{Column that contains the incident date. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{patient_DOB_col}{Column that contains the patient's date of birth. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{epatient_15_col}{Column representing the patient's numeric age agnostic
of unit.}

\item{epatient_16_col}{Column representing the patient's age unit ("Years",
"Months", "Days", "Hours", or "Minute").}

\item{eresponse_05_col}{Column containing response type codes.}

\item{esituation_11_col}{Column for primary impression fields, containing
ICD-10 codes.}

\item{esituation_12_col}{Column for secondary impression fields, containing
ICD-10 codes.}

\item{evitals_18_col}{Column for blood glucose levels.}

\item{evitals_23_col}{Column for Glasgow Coma Scale (GCS) scores.}

\item{evitals_26_col}{Column for AVPU alertness levels.}

\item{emedications_03_col}{Column for administered medications.}

\item{eprocedures_03_col}{Column for procedures performed.}

\item{...}{Additional arguments for summarization, passed to the summarize
function.}
}
\value{
A tibble summarizing results for three population groups (All,
Adults, and Peds) with the following columns:

\code{measure}: The name of the measure being calculated.
\code{pop}: Population type (All, Adults, Peds).
\code{numerator}: Count of incidents
where specific hypoglycemia best practices were administered.
\code{denominator}: Total count of incidents.
\code{prop}: Proportion of incidents
where specific hypoglycemia best practices were administered.
\code{prop_label}:
Proportion formatted as a percentage with a specified number of decimal
places.
}
\description{
The \code{hypoglycemia_01} function calculates the NEMSQA measure evaluating how
often hypoglycemic patients with altered mental status receive hypoglycemia
treatment.
}
\examples{

# Synthetic test data
test_data <- tibble::tibble(
  erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
  epatient_15 = c(34, 5, 45, 2, 60),  # Ages
  epatient_16 = c("Years", "Years", "Years", "Months", "Years"),
  eresponse_05 = rep(2205001, 5),
  esituation_11 = c(rep("E13.64", 3), rep("E16.2", 2)),
  esituation_12 = c(rep("E13.64", 2), rep("E16.2", 3)),
  emedications_03 = c(372326, 376937,
                      377980, 4850,
                      4832),
  evitals_18 = c(60, 59, 58, 57, 56),
  evitals_23 = c(16, 15, 14, 13, 12),
  evitals_26 = c("Alert", "Painful", "Verbal", "Unresponsive", "Alert"),
  eprocedures_03 = rep("710925007", 5)
)

# Run the function
hypoglycemia_01(
  df = test_data,
  erecord_01_col = erecord_01,
  epatient_15_col = epatient_15,
  epatient_16_col = epatient_16,
  eresponse_05_col = eresponse_05,
  esituation_11_col = esituation_11,
  esituation_12_col = esituation_12,
  emedications_03_col = emedications_03,
  evitals_18_col = evitals_18,
  evitals_23_col = evitals_23,
  evitals_26_col = evitals_26,
  eprocedures_03_col = eprocedures_03
)

}
\author{
Nicolas Foss, Ed.D., MS
}
