% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nemSym.R
\name{nemSym}
\alias{nemSym}
\title{Generating symmetric networks according to the selected local network mechanisms}
\usage{
nemSym(X, formula, theta, k = 5000, q)
}
\arguments{
\item{X}{Initial network; of class \code{matrix}.}

\item{formula}{The list of local netork mechanisms to be considered.}

\item{theta}{A vector with the mechanisms' weights/strengths.}

\item{k}{The number of iterations.}

\item{q}{The probability of establishing a link (i.e. expected/desired density).}
}
\value{
The list with the following elements:
\itemize{
\item \code{initialNetwork} - Initial network; of class \code{matrix}.
\item \code{finalNetwork} - Final (generated) network; of class \code{matrix}.
\item \code{formula} - The list of functions that define mechanisms used.
\item \code{theta} - A vector with the mechanisms' weights/strengths used.
\item \code{k} - The number of iterations.
\item \code{q} - The probability of establishing a link.
}
}
\description{
It generates random network considering the selected local network mechanisms.
}
\examples{
formula <- list(popularity, assortativity)
X <- matrix(sample(c(0,1), size = 9**2, replace = TRUE), nrow = 9)
diag(X) <- 0
nemSym(X = X, formula = formula, theta = c(1, 1), k = 100, q = 0.25)
}
\references{
Cugmas, M., DeLay, D., Žiberna, A., & Ferligoj, A. (2020). Symmetric core-cohesive blockmodel in preschool children’s interaction networks. PloS one, 15(1), e0226801.
}
\author{
Marjan Cugmas and Aleš Žiberna
}
