% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadTweets.R
\name{downloadTweets}
\alias{downloadTweets}
\title{Downloading Tweets based on a keyword list}
\usage{
downloadTweets(search_terms, n = 100, lang = "en")
}
\arguments{
\item{search_terms}{a string containing the search terms in Twitter format (use OR and AND to connect multiple search terms in one search)}

\item{n}{The number of Tweets downloaded. Please note that this limit is based on your Twitter account}

\item{lang}{The language of the Tweets. Default is English. Please refer to the Twitter API documentation for language codes}
}
\value{
a data frame containing the tweets as well as an additional column isNeed filled with 0
}
\description{
\code{downloadTweets} downloads Tweets containing specified keywords from the Twitter API
}
\details{
This function downloads Tweets for a specified keyword list, removes line breaks, adds a column isNeed filled with 0
}
\examples{
searchterm <- '"smart speaker" OR "homepod" OR "google home mini"'
\dontrun{
token <- twitterLogin()
currentTweets <- downloadTweets(searchterm, n = 180)
}
}
\author{
Dorian Proksch <dorian.proksch@hhl.de>
}
