% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndvtest.R
\name{ndvtest}
\alias{ndvtest}
\alias{llcont.maxLik2}
\alias{bread.maxLik2}
\alias{estfun.maxLik2}
\alias{logLik.maxLik2}
\title{Shi test for non-nested models}
\usage{
ndvtest(
  x,
  y,
  size = 0.05,
  pval = TRUE,
  nested = FALSE,
  vartest = FALSE,
  ndraws = 10000,
  diffnorm = 0.1,
  seed = 1,
  numbers = NULL,
  nd = TRUE,
  print.level = 0
)

\method{llcont}{maxLik2}(x, ...)

\method{bread}{maxLik2}(x, ...)

\method{estfun}{maxLik2}(x, ...)

\method{logLik}{maxLik2}(object, ...)
}
\arguments{
\item{x}{a first fitted model,}

\item{y}{a second fitted model,}

\item{size}{the size of the test,}

\item{pval}{should the p-value be computed ?}

\item{nested}{a boolean, \code{TRUE} for nested models,}

\item{vartest}{a boolean, if \code{TRUE}, the variance test is computed,}

\item{ndraws}{the number of draws for the simulations,}

\item{diffnorm}{a creuser,}

\item{seed}{the seed,}

\item{numbers}{a user provided matrix of random numbers}

\item{nd}{a boolean, if \code{TRUE} (the default) the non-degenarate Vuong test is computed,}

\item{print.level}{the level of details to be printed,}

\item{\dots}{further arguments,}

\item{object}{an object of class \code{maxLik2}.}
}
\value{
an object of class \code{"htest"}
}
\description{
The Shi test correct the bias of the Vuong test
}
\examples{

# A poisson model example from the nonnest2 man page
data("housing", package = "MASS")
house1 <- glm(Freq ~ Infl + Type + Cont, family = poisson, data = housing)
house2 <- glm(Freq ~ Infl + Sat,         family = poisson, data = housing)
nonnest2::vuongtest(house1, house2)
ndvtest(house1, house2)
data("bioChemists", package = "pscl")
bio1 <- glm(art ~ fem + mar + phd + ment, family=poisson, data=bioChemists)
bio2 <- pscl::hurdle(art ~ fem + mar + phd + ment, data=bioChemists)
bio3 <- pscl::zeroinfl(art ~ fem + mar + phd + ment, data=bioChemists)
nonnest2::vuongtest(bio3, bio2)
ndvtest(bio3, bio2)
}
\references{
\insertRef{VUON:89}{ndvtest}

\insertRef{SHI:15}{ndvtest}
}
\seealso{
the classical Vuong test is implemented in \code{pscl::vuong} and \code{nonnest2::vuongtest}.
}
\keyword{htest}
