% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncpen_cpp_wrap.R
\name{cv.ncpen}
\alias{cv.ncpen}
\title{Cross-validation for ncpen}
\usage{
cv.ncpen(y.vec, x.mat, family = c("gaussian", "binomial", "poisson"),
  penalty = c("scad", "mcp", "tlp", "lasso", "classo", "sridge", "mbridge",
  "mlog"), n.fold = 10, lambda = NULL, n.lambda = 100, r.lambda = 0.001,
  pen.weight = NULL, tau = switch(penalty, scad = 3.7, mcp = 3, tlp = 0.1,
  lasso = 1, classo = 2, sridge = 2, mbridge = 0.1, mlog = 0.1),
  gamma = 1e-06, ridge = 1e-06, df.max = 50, proj.min = 50,
  iter.max = 1000, b.eps = 1e-07, k.eps = 1e-06, x.standardize = TRUE,
  intercept = TRUE)
}
\arguments{
\item{y.vec}{(numeric vector) response vector.}

\item{x.mat}{(numeric matrix) design matrix. Each row is an observation vector.}

\item{family}{(character) regression model. Default is "\code{gaussian}".}

\item{penalty}{(character) penalty function. Default is "\code{scad}".}

\item{n.fold}{(numeric) the number of folds. Default value is 10. It should be 3 or greater.}

\item{lambda}{(numeric vector): user-specified sequence of \code{lambda} values.}

\item{n.lambda}{(numeric) the number of \code{lambda} values. Default is 100.}

\item{r.lambda}{(numeric) ratio of the smallest value for \code{lambda} to \code{lambda.max} (which derived from data) for which all coefficients are zero. Default is 1e-3.}

\item{pen.weight}{(numeric vector) penalty weights for each coefficient. If a penalty weight is set to zero,
the corresponding coefficient is always non-zero without shrinkage.
Note: the penalty weights are internally rescaled to sum to the number of variables, and the \code{lambda} sequence reflects this change.}

\item{tau}{(numeric) concavity parameter of the concave penalties (see reference). Default is 3.7 for \code{scad}, 3 for \code{mcp}, 2 for \code{classo} and \code{sridge}, 0.1 for \code{tlp}, \code{mbridge} and \code{mlog}.}

\item{gamma}{(numeric) additional tuning parameter for the \code{classo} and \code{sbridge}. Default value is 1e-6.}

\item{ridge}{(numeric) ridge effect (amount of ridge penalty). Default value is 1e-6.}

\item{df.max}{(numeric) the maximum number of nonzero coefficients. Default is 50.}

\item{proj.min}{(numeric) the minimum number of iterations which will be applied to projections (see details). Default value is 50.}

\item{iter.max}{(numeric) maximum number of iterations. Default value is 1e+3.}

\item{b.eps}{(numeric) convergence threshold for \eqn{L2} norms of coefficients vector. Default value is 1e-7.}

\item{k.eps}{(numeric) convergence threshold for KKT conditions. Default value is 1e-6.}

\item{x.standardize}{(logical) whether to standardize the \code{x.mat} prior to fitting the model.
The estimated coefficients are always restored to the original scale. Default value is \code{TRUE}.}

\item{intercept}{(logical) whether to include an intercept in the model. Default value is \code{TRUE}.}

\item{...}{other parameters are same as in \code{\link{ncpen}}.}
}
\value{
An object with S3 class \code{cv.ncpen}.
  \item{ncpen.fit}{the fitted \code{ncpen} object.}
  \item{opt.ebeta}{the optimal coefficients vector selected by using the squared-error loss in the cross-validation.}
  \item{opt.dbeta}{the optimal coefficients vector selected by using the deviance loss in the cross-validation.}
  \item{cv.error}{the averaged cross-validated error for each value of \code{lambda}s.}
  \item{cv.deviance}{the averaged cross-validated deviance for each value of \code{lambda}s.}
  \item{elambda}{the \code{lambda} sequence used for computing cv error.}
  \item{dlambda}{the \code{lambda} sequence used for computing cv deviance.}
  \item{opt.elambda}{the optimal value of \code{lambda} based on cv error.}
  \item{opt.dlambda}{the optimal value of \code{lambda} based on cv deviance.}
}
\description{
Performs k-fold cross-validation for nonconvex penalized regression models over a sequence of the regularization parameter lambda.
}
\details{
The function runs the \code{ncpen} function for \code{n.fold+1} times.
The first run is to get the sequence of \code{lambda} and then the rest runs are to compute the fit with each of the folds omitted. It provides the cross validated-error based on the squared-error loss and the deviance loss.
}
\examples{
s0 = sam.gen.fun(n=100,p=20,q=10,bmin=0.5,bmax=1,corr=0.5,family="gaussian", seed = 1234)
x.mat = s0$x.mat
y.vec = s0$y.vec

cvfit = cv.ncpen(y.vec=y.vec,x.mat=x.mat,family="gaussian",n.fold=10)  # not run !!!
coef.cv.ncpen(cvfit)
plot.cv.ncpen(cvfit)
fit = cvfit$ncpen.fit
opt = which(cvfit$opt.elambda==fit$lambda)
coef(fit)[,opt]

}
\references{
Kwon, S., Lee, S. and Kim, Y. (2016). Moderately clipped LASSO. \emph{Computational Statistics and Data Analysis}, \bold{92C}, 53-67.

Lee, S., Kwon, S. and Kim, Y. (2016). A modified local quadratic approximation algorithm for penalized optimization problems. \emph{Computational Statistics and Data Analysis}, \bold{94}, 275-286.

Choi, H., Kim, Y. and Kwon, S. (2013). Sparse bridge estimation with a diverging number of parameters. \emph{Statistics and Its Interface}, \bold{6}, 231-242.
}
\seealso{
\code{\link{ncpen}}, \code{\link{plot.cv.ncpen}}, \code{\link{coef.cv.ncpen}}
}
\author{
Dongshin Kim, Sunghoon Kwon, Sangin Lee

Maintainer: Dongshin Kim<dongshin.kim@outlook.com>, Sunghoon Kwon<shkwon0522@gmail.com>
}
