% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFAxisLatitude.R
\docType{class}
\name{CFAxisLatitude}
\alias{CFAxisLatitude}
\title{Latitude CF axis object}
\description{
This class represents a latitude axis. Its values are numeric.
This class adds some logic that is specific to latitudes, such as their
range, orientation and meaning.
}
\section{Super classes}{
\code{\link[ncdfCF:CFObject]{ncdfCF::CFObject}} -> \code{\link[ncdfCF:CFData]{ncdfCF::CFData}} -> \code{\link[ncdfCF:CFAxis]{ncdfCF::CFAxis}} -> \code{\link[ncdfCF:CFAxisNumeric]{ncdfCF::CFAxisNumeric}} -> \code{CFAxisLatitude}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{friendlyClassName}}{(read-only) A nice description of the class.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CFAxisLatitude-new}{\code{CFAxisLatitude$new()}}
\item \href{#method-CFAxisLatitude-copy}{\code{CFAxisLatitude$copy()}}
\item \href{#method-CFAxisLatitude-copy_with_values}{\code{CFAxisLatitude$copy_with_values()}}
\item \href{#method-CFAxisLatitude-subset}{\code{CFAxisLatitude$subset()}}
\item \href{#method-CFAxisLatitude-append}{\code{CFAxisLatitude$append()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="append_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-append_attribute'><code>ncdfCF::CFObject$append_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-attribute'><code>ncdfCF::CFObject$attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="attributes_identical"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-attributes_identical'><code>ncdfCF::CFObject$attributes_identical()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="delete_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-delete_attribute'><code>ncdfCF::CFObject$delete_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="print_attributes"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-print_attributes'><code>ncdfCF::CFObject$print_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="set_attribute"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-set_attribute'><code>ncdfCF::CFObject$set_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFObject" data-id="write_attributes"><a href='../../ncdfCF/html/CFObject.html#method-CFObject-write_attributes'><code>ncdfCF::CFObject$write_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFData" data-id="dim"><a href='../../ncdfCF/html/CFData.html#method-CFData-dim'><code>ncdfCF::CFData$dim()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="attach_to_group"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-attach_to_group'><code>ncdfCF::CFAxis$attach_to_group()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="can_append"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-can_append'><code>ncdfCF::CFAxis$can_append()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="configure_terms"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-configure_terms'><code>ncdfCF::CFAxis$configure_terms()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="copy_terms"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-copy_terms'><code>ncdfCF::CFAxis$copy_terms()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="detach"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-detach'><code>ncdfCF::CFAxis$detach()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="peek"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-peek'><code>ncdfCF::CFAxis$peek()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="shard"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-shard'><code>ncdfCF::CFAxis$shard()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxis" data-id="write"><a href='../../ncdfCF/html/CFAxis.html#method-CFAxis-write'><code>ncdfCF::CFAxis$write()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxisNumeric" data-id="brief"><a href='../../ncdfCF/html/CFAxisNumeric.html#method-CFAxisNumeric-brief'><code>ncdfCF::CFAxisNumeric$brief()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxisNumeric" data-id="identical"><a href='../../ncdfCF/html/CFAxisNumeric.html#method-CFAxisNumeric-identical'><code>ncdfCF::CFAxisNumeric$identical()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxisNumeric" data-id="indexOf"><a href='../../ncdfCF/html/CFAxisNumeric.html#method-CFAxisNumeric-indexOf'><code>ncdfCF::CFAxisNumeric$indexOf()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxisNumeric" data-id="print"><a href='../../ncdfCF/html/CFAxisNumeric.html#method-CFAxisNumeric-print'><code>ncdfCF::CFAxisNumeric$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxisNumeric" data-id="range"><a href='../../ncdfCF/html/CFAxisNumeric.html#method-CFAxisNumeric-range'><code>ncdfCF::CFAxisNumeric$range()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ncdfCF" data-topic="CFAxisNumeric" data-id="slice"><a href='../../ncdfCF/html/CFAxisNumeric.html#method-CFAxisNumeric-slice'><code>ncdfCF::CFAxisNumeric$slice()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisLatitude-new"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisLatitude-new}{}}}
\subsection{Method \code{new()}}{
Create a new instance of this class.

Creating a new latitude axis is more easily done with the
\code{\link[=makeLatitudeAxis]{makeLatitudeAxis()}} function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisLatitude$new(
  var,
  group,
  values,
  start = 1L,
  count = NA,
  attributes = data.frame()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{var}}{The name of the axis when creating a new axis. When reading an
axis from file, the \link{NCVariable} object that describes this instance.}

\item{\code{group}}{The \link{CFGroup} that this instance will live in.}

\item{\code{values}}{Optional. The values of the axis in a vector. The values
have to be numeric within the range (-90, 90) and monotonic. Ignored
when argument \code{var} is a NCVariable object.}

\item{\code{start}}{Optional. Integer index where to start reading axis data
from file. The index may be \code{NA} to start reading data from the start.}

\item{\code{count}}{Optional. Number of elements to read from file. This may be
\code{NA} to read to the end of the data.}

\item{\code{attributes}}{Optional. A \code{data.frame} with the attributes of the
axis. When an empty \code{data.frame} (default) and argument \code{var} is an
NCVariable instance, attributes of the axis will be taken from the
netCDF resource.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisLatitude-copy"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisLatitude-copy}{}}}
\subsection{Method \code{copy()}}{
Create a copy of this axis. The copy is completely separate
from \code{self}, meaning that both \code{self} and all of its components are made
from new instances.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisLatitude$copy(name = "", group)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name for the new axis. If an empty string is passed, will
use the name of this axis.}

\item{\code{group}}{The \link{CFGroup} where the copy of this axis will live.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The newly created axis.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisLatitude-copy_with_values"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisLatitude-copy_with_values}{}}}
\subsection{Method \code{copy_with_values()}}{
Create a copy of this axis but using the supplied values.
The attributes are copied to the new axis. Boundary values and
auxiliary coordinates are not copied.

After this operation the attributes of the newly created axes may not
be accurate, except for the "actual_range" attribute. The calling code
should set, modify or delete attributes as appropriate.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisLatitude$copy_with_values(name = "", group, values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name for the new axis. If an empty string is passed, will
use the name of this axis.}

\item{\code{group}}{The \link{CFGroup} where the copy of this axis will live.}

\item{\code{values}}{The values to the used with the copy of this axis.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The newly created axis.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisLatitude-subset"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisLatitude-subset}{}}}
\subsection{Method \code{subset()}}{
Return a latitude axis spanning a smaller coordinate range.
This method returns an axis which spans the range of indices given by
the \code{rng} argument.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisLatitude$subset(name = "", group, rng = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name for the new axis. If an empty string is passed
(default), will use the name of this axis.}

\item{\code{group}}{The \link{CFGroup} where the copy of this axis will live.}

\item{\code{rng}}{The range of indices whose values from this axis to include in
the returned axis. If the value of the argument is \code{NULL}, return a
copy of the axis.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{CFAxisLatitude} instance covering the indicated range of
indices. If the value of the argument \code{rng} is \code{NULL}, return a copy of
\code{self} as the new axis.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFAxisLatitude-append"></a>}}
\if{latex}{\out{\hypertarget{method-CFAxisLatitude-append}{}}}
\subsection{Method \code{append()}}{
Append a vector of values at the end of the current values
of the axis. Boundary values are appended as well but if either this
axis or the \code{from} axis does not have boundary values, neither will the
resulting axis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFAxisLatitude$append(from)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{from}}{An instance of \code{CFAxisLatitude} whose values to append to the
values of this axis.}

\item{\code{group}}{The \link{CFGroup} where the copy of this axis will live.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{CFAxisLatitude} instance with values from this axis and
the \code{from} axis appended.
}
}
}
