% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFObject.R
\docType{class}
\name{CFObject}
\alias{CFObject}
\title{CF base object}
\description{
This class is a basic ancestor to all classes that represent CF
objects, specifically data variables and axes. More useful classes use this
class as ancestor.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{NCvar}}{The \link{NCVariable} instance that this CF object represents.}

\item{\code{group}}{The \link{NCGroup} that this object is located in.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{friendlyClassName}}{(read-only) A nice description of the class.}

\item{\code{id}}{(read-only) The identifier of the CF object.}

\item{\code{name}}{(read-only) The name of the CF object.}

\item{\code{fullname}}{(read-only) The fully-qualified name of the CF object.}

\item{\code{attributes}}{(read-only) A \code{data.frame} with the attributes of the
CF object.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CFObject-new}{\code{CFObject$new()}}
\item \href{#method-CFObject-attribute}{\code{CFObject$attribute()}}
\item \href{#method-CFObject-print_attributes}{\code{CFObject$print_attributes()}}
\item \href{#method-CFObject-set_attribute}{\code{CFObject$set_attribute()}}
\item \href{#method-CFObject-append_attribute}{\code{CFObject$append_attribute()}}
\item \href{#method-CFObject-delete_attribute}{\code{CFObject$delete_attribute()}}
\item \href{#method-CFObject-write_attributes}{\code{CFObject$write_attributes()}}
\item \href{#method-CFObject-clone}{\code{CFObject$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFObject-new"></a>}}
\if{latex}{\out{\hypertarget{method-CFObject-new}{}}}
\subsection{Method \code{new()}}{
Create a new CF object instance from a variable in a netCDF
resource. This method is called upon opening a netCDF resource. It is
rarely, if ever, useful to call this constructor directly from the
console. Instead, use the methods from higher-level classes such as
\link{CFVariable}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFObject$new(nc_var, group)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nc_var}}{The \link{NCVariable} instance upon which this CF object is
based.}

\item{\code{group}}{The \link{NCGroup} that this object is located in.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{CFobject} instance.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFObject-attribute"></a>}}
\if{latex}{\out{\hypertarget{method-CFObject-attribute}{}}}
\subsection{Method \code{attribute()}}{
Retrieve attributes of any CF object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFObject$attribute(att, field = "value")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{att}}{Vector of character strings of attributes to return.}

\item{\code{field}}{The field of the attribute to return values from. This must
be "value" (default) or "type".}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If the \code{field} argument is "type", a character string. If \code{field}
is "value", a single value of the type of the attribute, or a vector
when the attribute has multiple values. If no attribute is named with a
value of argument \code{att} \code{NA} is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFObject-print_attributes"></a>}}
\if{latex}{\out{\hypertarget{method-CFObject-print_attributes}{}}}
\subsection{Method \code{print_attributes()}}{
Print the attributes of the CF object to the console.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFObject$print_attributes(width = 50L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{width}}{The maximum width of each column in the \code{data.frame} when
printed to the console.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFObject-set_attribute"></a>}}
\if{latex}{\out{\hypertarget{method-CFObject-set_attribute}{}}}
\subsection{Method \code{set_attribute()}}{
Add an attribute. If an attribute \code{name} already exists, it
will be overwritten.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFObject$set_attribute(name, type, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the attribute. The name must begin with a letter
and be composed of letters, digits, and underscores, with a maximum
length of 255 characters. UTF-8 characters are not supported in
attribute names.}

\item{\code{type}}{The type of the attribute, as a string value of a netCDF data
type.}

\item{\code{value}}{The value of the attribute. This can be of any supported
type, including a vector or list of values. Matrices, arrays and like
compound data structures should be stored as a data variable, not as an
attribute and they are thus not allowed. In general, an attribute
should be a character value, a numeric value, a logical value, or a
short vector or list of any of these. Values passed in a list will be
coerced to their common mode.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFObject-append_attribute"></a>}}
\if{latex}{\out{\hypertarget{method-CFObject-append_attribute}{}}}
\subsection{Method \code{append_attribute()}}{
Append the text value of an attribute. If an attribute
\code{name} already exists, the \code{value} will be appended to the existing
value of the attribute. If the attribute \code{name} does not exist it will
be created. The attribute must be of "NC_CHAR" or "NC_STRING" type; in
the latter case having only a single string value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFObject$append_attribute(name, value, sep = "; ", prepend = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the attribute. The name must begin with a letter
and be composed of letters, digits, and underscores, with a maximum
length of 255 characters. UTF-8 characters are not supported in
attribute names.}

\item{\code{value}}{The character value of the attribute to append. This must be
a character string.}

\item{\code{sep}}{The separator to use. Default is \code{"; "}.}

\item{\code{prepend}}{Logical to flag if the supplied \code{value} should be placed
before the existing value. Default is \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFObject-delete_attribute"></a>}}
\if{latex}{\out{\hypertarget{method-CFObject-delete_attribute}{}}}
\subsection{Method \code{delete_attribute()}}{
Delete an attribute. If an attribute \code{name} is not present
this method simply returns.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFObject$delete_attribute(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the attribute to delete.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFObject-write_attributes"></a>}}
\if{latex}{\out{\hypertarget{method-CFObject-write_attributes}{}}}
\subsection{Method \code{write_attributes()}}{
Write the attributes of this object to a netCDF file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFObject$write_attributes(nc, nm)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nc}}{The handle to the netCDF file opened for writing.}

\item{\code{nm}}{The NC variable name or "NC_GLOBAL" to write the attributes to.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CFObject-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CFObject-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CFObject$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
