% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncdfDimension.R, R/ncdfVariable.R,
%   R/ncdfDataset.R, R/ncdfDimensionCharacter.R, R/ncdfDimensionNumeric.R,
%   R/ncdfDimensionTime.R
\name{ncdfDimnames}
\alias{ncdfDimnames}
\alias{dimnames,ncdfVariable-method}
\alias{dimnames,ncdfDataset-method}
\alias{dimnames,ncdfDimensionCharacter-method}
\alias{dimnames,ncdfDimensionNumeric-method}
\alias{dimnames,ncdfDimensionTime-method}
\title{Dimnames of an \code{ncdfObject} instance}
\usage{
\S4method{dimnames}{ncdfVariable}(x)

\S4method{dimnames}{ncdfDataset}(x)

\S4method{dimnames}{ncdfDimensionCharacter}(x)

\S4method{dimnames}{ncdfDimensionNumeric}(x)

\S4method{dimnames}{ncdfDimensionTime}(x)
}
\arguments{
\item{x}{An \code{ncdfObject} whose dimension names to retrieve. This could be
\code{ncdfDataset}, \code{ncdfVariable}, \code{ncdfDimensionNumeric} or \code{ncdfDimensionTime}.}
}
\value{
A vector as described in the Description section.
}
\description{
Retrieve the dimension names of an \code{ncdfCF} object. The return
value differs depending on the type of object:
\itemize{
\item \code{ncdfDataset}, \code{ncdfVariable}: The dimnames are returned as a vector of the
names of the dimensions of the dataset or variable. Note that this differs
markedly from the \code{base::dimnames()} functionality.
\item \code{ncdfDimensionNumeric}: The values of the elements along the dimension as a
numeric vector.
\item \code{ncdfDimensionCharacter}: The values of the elements along the dimension as
a character vector.
\item \code{ncdfDimensionTime}: The values of the elements along the dimension as a
character vector containing timestamps in ISO8601 format. This could be dates
or date-times if time information is available in the dimension.
}
}
\examples{
fn <- system.file("extdata",
  "pr_day_EC-Earth3-CC_ssp245_r1i1p1f1_gr_20240101-20241231_vncdfCF.nc",
  package = "ncdfCF")
ds <- open_ncdf(fn)

# ncdfDataset
dimnames(ds)

# ncdfVariable
pr <- ds[["pr"]]
dimnames(pr)

# ncdfDimensionNumeric
lon <- ds[["lon"]]
dimnames(lon)

# ncdfDimensionTime
t <- ds[["time"]]
dimnames(t)
}
