% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.r
\name{get.cluster.worker.subsets}
\alias{get.cluster.worker.subsets}
\title{Get subsets to be distributed to workers}
\usage{
get.cluster.worker.subsets(
  num.vals,
  dim.size,
  dim.axes,
  axis.to.split.on,
  min.num.chunks = 1
)
}
\arguments{
\item{num.vals}{The maximum number of values to process at once.}

\item{dim.size}{The sizes of the dimensions of the data to be processed.}

\item{dim.axes}{The axes of the data, as returned by \code{nc.get.dim.axes}.}

\item{axis.to.split.on}{The axis (X, Y, T, etc) to split the data on.}

\item{min.num.chunks}{The minimum number of chunks to generate, even if the chunks are considerably smaller than \code{num.vals}.}
}
\value{
A list of lists describing subsets in a suitable form to be passed to \code{nc.put.var.subsets.by.axes} or \code{nc.get.var.subsets.by.axes}.
}
\description{
Get subsets to be distributed to workers.
}
\details{
Given a desired number of values (\code{num.vals}), the sizes of the dimensions (\code{dim.size}), the corresponding axes (\code{dim.axes}), the desired axis to split on (\code{axis.to.split.on}), and optionally the minimum number of chunks to return (\code{min.num.chunks}), returns a list of lists of subsets appropriate to be passed to \code{nc.put.var.subsets.by.axes} or \code{nc.get.var.subsets.by.axes}.

This functionality is useful when you want to keep memory consumption down but want to maximize the amount read in at one time to make the best use of available I/O bandwidth.
}
\examples{
## Get a subset from an example
subsets <- get.cluster.worker.subsets(1E7, c(128, 64, 50000),
                                      c(lon="X", lat="Y", time="T"), "Y")

}
