\name{get.split.filename.cmip5}
\alias{get.split.filename.cmip5}
\title{Splits up a CMIP5 filename}
\usage{
get.split.filename.cmip5(cmip5.file)
}
\arguments{
  \item{cmip5.file}{The filename to be split.}
}
\value{
A vector containing the variable (var), time resolution
(tres), model (model), emissions scenario (emissions), run
(run), time range (trange), time start (tstart) and time
end (tend) for the file.
}
\description{
Splits up a CMIP5 filename into its component parts.
}
\details{
As the CMIP5 conventions define the format of filenames,
quite a bit of data can be extracted from the filename
alone. This function makes that process easier by splitting
up the given CMIP5 filename, returning a named vector
consisting of the variable, time resolution, model,
emissions scenario, run, time range, and time start and
end.
}
\examples{
## Split up filename into component bits
split.bits <- get.split.filename.cmip5(
                "pr/pr_day_MRI-CGCM3_historical_r1i1p1_18500101-20051231.nc")
}
\references{
\url{http://cmip-pcmdi.llnl.gov/cmip5/docs/CMIP5_output_metadata_requirements.pdf}
}

