% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/ncappc.R
\name{ncappc}
\alias{ncappc}
\title{Performs NCA calculations and population PK model diagnosis.}
\usage{
ncappc(obsFile = NULL, simFile = NULL, grNm = NULL, grp = NULL,
  flNm = NULL, flag = NULL, doseNm = NULL, dose = NULL,
  concUnit = NULL, timeUnit = NULL, doseUnit = NULL,
  doseNormUnit = NULL, obsLog = "FALSE", simLog = "FALSE",
  psnOut = "FALSE", idNmObs = "ID", timeNmObs = "TIME",
  concNmObs = "DV", idNmSim = "ID", timeNmSim = "TIME",
  concNmSim = "DV", AUCTimeRange = NULL, backExtrp = "FALSE",
  LambdaTimeRange = NULL, LambdaExclude = NULL, doseAmtNm = NULL,
  adminType = "extravascular", doseType = "ns", Tau = NULL, TI = NULL,
  method = "mixed", blqNm = NULL, blqExcl = 1, evid = "FALSE",
  evidIncl = 0, mdv = "FALSE", filterNm = NULL, filterExcl = NULL,
  negConcExcl = "FALSE", param = c("AUClast", "Cmax"),
  timeFormat = "number", dateColNm = NULL, dateFormat = NULL,
  spread = "npi", tabCol = c("AUClast", "Cmax", "Tmax", "AUCINF_obs",
  "Vz_obs", "Cl_obs", "HL_Lambda_z"), figFormat = "tiff", noPlot = "FALSE",
  printOut = "TRUE", studyName = NULL)
}
\arguments{
\item{obsFile}{Observed concentration-time data from an internal data frame
or an external table with comma, tab or space as separator}

\item{simFile}{NONMEM simulation output with the simulated concentration-time
data from an internal data frame or an external table (\strong{"NULL"})}

\item{grNm}{Column name for population stratifier (\strong{"NULL"})}

\item{grp}{Stratification ID (e.g c(1,2)) (\strong{"NULL"})}

\item{flNm}{Column name for popualtion stratifier (\strong{"NULL"})}

\item{flag}{Stratification ID (e.g. c(1,2)) (\strong{"NULL"})}

\item{doseNm}{Column name to specify dose identifiers (\strong{"NULL"})}

\item{dose}{Dose identifiers to be used (c(1,2)) (\strong{"NULL"})}

\item{concUnit}{Unit of concentration ("ng/mL") (\strong{"[M].[L]^-3"})}

\item{timeUnit}{Unit of time ("h") (\strong{"[T]})}

\item{doseUnit}{Unit of dose amount ("ng") (\strong{"[M]"})}

\item{doseNormUnit}{Normalization factor of dose amount if used (kg)
(\strong{"NULL"})}

\item{obsLog}{Concentration in observed data in logarithmic form (TRUE,
FALSE) (\strong{"FALSE"})}

\item{simLog}{Concentration in simulated data in logarithmic form (TRUE,
FALSE) (\strong{"FALSE"})}

\item{psnOut}{observed data is an output from PsN or in NONMEM output format
(TRUE, FALSE) (\strong{"FALSE"})}

\item{idNmObs}{Column name for ID in observed data (\strong{"ID"})}

\item{timeNmObs}{Column name for time in observed data (\strong{"TIME"})}

\item{concNmObs}{Column name for concentration in observed data
(\strong{"DV"})}

\item{idNmSim}{Column name for ID in simulated data (\strong{"ID"})}

\item{timeNmSim}{Column name for time in simulated data (\strong{"TIME"})}

\item{concNmSim}{Column name for concentration in simulated data
(\strong{"DV"})}

\item{AUCTimeRange}{User-defined window of time used to estimate AUC
(\strong{"NULL"})}

\item{backExtrp}{If back-extrapolation is needed for AUC (TRUE or FALSE)
(\strong{"FALSE"})}

\item{LambdaTimeRange}{User-defined window of time to estimate elimination
rate-constant (\strong{"NULL"})}

\item{LambdaExclude}{User-defined excluded observation time points for
estimation of elimination rate-constant (\strong{"NULL"})}

\item{doseAmtNm}{Column name to specify dose amount (\strong{"NULL"})}

\item{adminType}{Route of administration
(iv-bolus,iv-infusion,extravascular) (\strong{"extravascular"})}

\item{doseType}{Steady-state (ss) or nonsteady-state (ns) dose
(\strong{"ns"})}

\item{Tau}{Dosing interval for steady-state data (\strong{"NULL"})}

\item{TI}{Infusion duration (\strong{"NULL"})}

\item{method}{linear, loglinear or mixed (\strong{"mixed"})}

\item{blqNm}{Name of BLQ column if used (\strong{"NULL"})}

\item{blqExcl}{Excluded BLQ value or logical condition (e.g. 1 or ">=1" or
c(1,">3")) (\strong{"1"})}

\item{evid}{Use EVID (TRUE, FALSE) (\strong{"FALSE"})}

\item{evidIncl}{Included EVID (\strong{"0"})}

\item{mdv}{Use MDV (TRUE(includes data for MDV==0), FALSE) (\strong{"FALSE"})}

\item{filterNm}{Column name for filter (\strong{"NULL"})}

\item{filterExcl}{Filter identifier or logical condition used for row
exclusion (e.g. c(1, 2, "<20", ">=100", "!=100")) (\strong{"NULL"})}

\item{negConcExcl}{Exclude -ve conc (\strong{"FALSE"})}

\item{param}{NCA parameters (AUClast, AUClower_upper, AUCINF_obs,
AUCINF_pred, AUMClast, Cmax, Tmax, HL_Lambda_z) (c(\strong{"AUClast",
"Cmax"}))}

\item{timeFormat}{time format (number, H:M, H:M:S) (\strong{"number"})}

\item{dateColNm}{colunm name for date if used (Date, DATE) (\strong{"NULL"})}

\item{dateFormat}{date format (D-M-Y, D/M/Y or any other combination of
D,M,Y) (\strong{"NULL"})}

\item{spread}{Measure of the spread of simulated data (ppi (95\% parametric
prediction interval) or npi (95\% nonparametric prediction interval))
(\strong{"npi"})}

\item{tabCol}{Output columns to be printed in the report in addition to ID,
dose and population strata information (list of NCA metrics in a string
array) (\strong{c("AUClast", "Cmax", "Tmax", "AUCINF_obs", "Vz_obs",
"Cl_obs", "HL_Lambda_z")})}

\item{figFormat}{format of the produced figures (bmp, jpeg, tiff, png)
(\strong{"tiff"})}

\item{noPlot}{Perform only NCA calculations without any plot generation
(TRUE, FALSE) (\strong{"FALSE"})}

\item{printOut}{Write/print output on the disk. No plot will be saved if
noPlot is set to TRUE (TRUE, FALSE) (\strong{"TRUE"})}

\item{studyName}{Name of the study to be added as a description in the report
  (\strong{"NULL"})}
}
\value{
NCA results and diagnostic test results
}
\description{
\pkg{ncappc} is a flexible tool, to
\enumerate{
 \item perform a traditional NCA
 \item perform simulation-based posterior predictive checks for a
population PK model using NCA metrics.
}
}
\details{
Non-compartmental analysis (NCA) calculates pharmacokinetic (PK) metrics
related to the systemic exposure to a drug following administration, e.g.
area under the concentration-time curve and peak concentration. \pkg{ncappc}
performs a traditional NCA using the observed plasma concentration-time data.
In the presence of simulated plasma concentration-time data, \pkg{ncappc}
also performs simulation-based posterior predictive checks (ppc) using NCA
metrics for the corresponding population PK (PopPK) model used to generate
the simulated data. The diagnostic analysis is performed at the population as
well as the individual level. The distribution of the simulated population
means of each NCA metric is compared with the corresponding observed
population mean. The individual level comparison is performed based on the
deviation of the mean of any NCA metric based on simulations for an
individual from the corresponding NCA metric obtained from the observed data.
Additionaly, \pkg{ncappc} reports the normalized prediction distribution
error (NPDE) of the simulated NCA metrics for each individual and their
distribution within a population. \pkg{ncappc} produces two default outputs
depending on the type of analysis performed, i.e., traditional NCA and PopPK
diagnosis. The PopPK diagnosis feature of \pkg{ncappc} produces 7 sets of
graphical outputs to assess the ability of a population model to simulate the
concentration-time profile of a drug and thereby identify model
misspecification. In addition, tabular outputs are generated showing the
values of the NCA metrics estimated from the observed and the simulated data,
along with the deviation, NPDE, regression parameters used to estimate the
elimination rate constant and the related population statistics. The default
values of the arguments used in \pkg{ncappc} are shown in \strong{bold}.
}

