% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbc4va_main.R
\name{summary.nbc}
\alias{summary.nbc}
\title{Summarize a NBC model with metrics}
\usage{
\method{summary}{nbc}(object, top = 5, id = NULL, csmfa.obs = NULL, ...)
}
\arguments{
\item{object}{The result \code{\link{nbc}} object.}

\item{top}{A number that produces top causes depending on \emph{id}:
\itemize{
  \item If (\emph{id} is char): provide the \emph{top} causes of the case by probability
  \item If (\emph{id} is NULL): provide the \emph{top} causes by predicted Cause Specific Mortality Fractions (CSMF)
}}

\item{id}{A character representing a case id in the test data.}

\item{csmfa.obs}{A character vector of the true causes for calculating the CSMF accuracy.}

\item{...}{Additional arguments to be passed if applicable}
}
\value{
out A summary object built from a \code{\link{nbc}} object with modifications/additions:
\itemize{
  \item If (\emph{id} is char):
    \itemize{
      \item Additions to a \code{\link{nbc}} object:
        \itemize{
          \item $id (char): the case \emph{id} chosen by the user
          \item $top (numeric): the input number of \emph{top} causes for \emph{id}
          \item $top.prob (vectorof double): the \emph{top} probabilities for \emph{id}
        }
      \item The following are modified from a nbc object to be \emph{id} specific:\cr $test, $test.ids, $test.causes, $obs.causes, $prob, $prob.causes, $pred, $pred.causes
  }
  \item If (\emph{id} is NULL):
  \itemize{
    \item Additions to the \code{\link{nbc}} object:
    \itemize{
      \item * indicates that the item is only available if \emph{test} causes are known
      \item ** indicates that the item ignores * if \emph{csmfa.obs} is given
      \item $top.csmf.pred (vectorof double): the \emph{top} predicted CSMFs by cause
      \item $top.csmf.obs* (vectorof double): the \emph{top} observed CSMFs by cause
      \item $metrics.all** (vectorof double): a numeric vector of overall metrics.
        \itemize{
          \item Names: TruePositives, TrueNegatives, FalsePositives, FalseNegatives, Accuracy, Sensitivity, PCCC, CSMFMaxError, CSMFaccuracy
          \item TruePositives* (double): total number of true positives
          \item TrueNegatives* (double): total number of true negatives
          \item FalsePositives* (double): total number of false positives
          \item FalseNegatives* (double): total number of false negatives
          \item Sensitivity* (double): the overall sensitivity
          \item PCCC* (double): the partial chance corrected concordance
          \item CSMFMaxError** (double): the maximum Cause Specific Mortality Fraction Error
          \item CSMFaccuracy** (double): the Cause Specific Mortaliy Fraction accuracy
        }
      \item $metrics.causes (dataframe): a perfomance table of metrics by cause.
        \itemize{
          \item Columns: Cause, Sensitivity, CSMFpredicted, CSMFobserved
          \item Cause (vectorof char): The unique causes from both the \emph{obs} and \emph{pred} inputs
          \item Sensitivity* (vectorof double): the sensitivity for a cause
          \item CSMFpredicted (vectorof double): the cause specific mortality fraction for a cause given the predicted deaths
          \item CSMFobserved* (vectorof double): the cause specific mortality fraction for a cause given the observed deaths
          \item TruePositives (vectorof double): The total number of true positives per cause
          \item TrueNegatives (vectorof double): The total number of true negatives per cause
          \item FalsePositives (vectorof double): The total number of false positives per cause
          \item FalseNegatives (vectorof double): The total number of false negatives per cause
          \item PredictedFrequency (vectorof double): The occurence of a cause in the \emph{pred} input
          \item ObservedFrequency (vectorof double): The occurence of a cause in the \emph{obs} input
          \item Example:
            \tabular{cccc}{
              Cause \tab Sensitivity \tab Metric-n.. \cr
              HIV \tab 0.5 \tab #.. \cr
              Stroke \tab 0.5 \tab #..
            }
        }
    }
  }
}
}
\description{
Summarizes the results from a \code{\link{nbc}} object. The summary
can be either for a particular case or for the entirety of cases.
}
\details{
See \href{https://rrwen.github.io/nbc4va/methods}{Methods documentation} for details on calculations and metrics.
}
\examples{
library(nbc4va)
data(nbc4vaData)

# Run naive bayes classifier on random train and test data
train <- nbc4vaData[1:50, ]
test <- nbc4vaData[51:100, ]
results <- nbc(train, test)

# Obtain a summary for the results
brief <- summary(results, top=2)  # top 2 causes by CSMF for all test data
briefID <- summary(results, id="v48")  # top 5 causes by probability for case "v48"

}
\seealso{
Other main functions: \code{\link{nbc}},
  \code{\link{plot.nbc}}, \code{\link{print.nbc_summary}}
}
