% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbc4va_internal.R
\name{internalGetMetrics}
\alias{internalGetMetrics}
\title{Calculate overall performance metrics}
\usage{
internalGetMetrics(pred, obs, causes = unique(c(pred, obs)),
  csmfa.obs = NULL, causeMetrics = internalGetCauseMetrics(pred, obs,
  causes))
}
\arguments{
\item{pred}{Chracter vector of predicted causes for each case.}

\item{obs}{Character vector of observed causes for each case.}

\item{causes}{Character vector of all possible causes including ones that are not in the \emph{pred} or \emph{obs}.}

\item{csmfa.obs}{A character vector of the true causes for calculating the CSMF accuracy.}

\item{causeMetrics}{Dataframe of a performance metrics per cause (see \code{\link{internalGetCauseMetrics}}):
\itemize{
  \item Columns: Cause, TruePositives, TrueNegatives, FalsePositives, FalseNegatives, PredictedFrequency, ObservedFrequency, Sensitivity, CSMFpredicted, CSMFobserved
  \item Cause (vectorof char): The unique causes from both the \emph{obs} and \emph{pred} inputs
  \item TruePositives (vectorof double): The total number of true positives per cause
  \item TrueNegatives (vectorof double): The total number of true negatives per cause
  \item FalsePositives (vectorof double): The total number of false positives per cause
  \item FalseNegatives (vectorof double): The total number of false negatives per cause
  \item PredictedFrequency (vectorof double): The occurence of a cause in the \emph{pred} input
  \item ObservedFrequency (vectorof double): The occurence of a cause in the \emph{obs} input
  \item Sensitivity (vectorof double): the sensitivity for a cause
  \item CSMFpredicted (vectorof double): the cause specific mortality fraction for a cause given the predicted deaths
  \item CSMFobserved (vectorof double): the cause specific mortality fraction for a cause given the observed deaths
}}
}
\value{
metrics Named numeric vector of performance metrics (see \href{https://rrwen.github.io/nbc4va/methods}{Methods documentation}):
\itemize{
  \item Names: TruePositives, TrueNegatives, FalsePositives, FalseNegatives, Accuracy, Sensitivity, Specificity, PCCC, CSMFMaxError, CSMFaccuracy
  \item TruePositives (double): total number of true positives
  \item TrueNegatives (double): total number of true negatives
  \item FalsePositives (double): total number of false positives
  \item FalseNegatives (double): total number of false negatives
  \item Sensitivity (double): the overall sensitivity
  \item PCCC (double): the partial chance corrected concordance
  \item CSMFMaxError (double): the maximum Cause Specific Mortality Fraction Error
  \item CSMFaccuracy (double): the Cause Specific Mortaliy Fraction accuracy
}
}
\description{
A vector providing overall performance metrics based on input predicted and observed cases.
}
\details{
Developer Note: Depends on the \code{\link{internalGetCSMFAcc}} function to get the CSMF Accuracy.
}
\examples{
library(nbc4va)
pred <- c("HIV", "Stroke", "HIV", "Stroke")
obs <- c("HIV", "HIV", "Stroke", "Stroke")
metrics <- nbc4va:::internalGetMetrics(pred, obs)

}
\seealso{
Other internal functions: \code{\link{internalGetCSMFAcc}},
  \code{\link{internalGetCSMFMaxError}},
  \code{\link{internalGetCauseMetrics}},
  \code{\link{internalNBC}}
}
\keyword{internal}
