% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcR.R
\name{estimateRi}
\alias{estimateRi}
\title{Estimates individual-level reproductive numbers}
\usage{
estimateRi(df, indIDVar, dateVar, pVar)
}
\arguments{
\item{df}{The name of the dateset with transmission probabilities}

\item{indIDVar}{The variable name (in quotes) of the individual ID varaibles 
(data frame \code{df} must have variables called \code{<indIDVar>.1}
and \code{<indIDVar>.2}).}

\item{dateVar}{The variable name (in quotes) of the dates that the individuals
are observed (data frame \code{df}  must have variables called \code{<dateVar>.1}
and \code{<dateVar>.2}).}

\item{pVar}{The variable name (in quotes) of the transmission probabilities.}
}
\value{
A data frame with the individual-level reproductive numbers. Column names:
     \itemize{
       \item \code{<indIDVar>} - the individual ID with name specified.
       \item \code{<dateVar>} - the date the individual was observed with name specified.
       \item \code{Ri} - the individual-level reproductive number.
       \item \code{nInfectees} - the number of possible infectees for this individual.
     }
}
\description{
The function \code{estimateRi} uses relative transmission probabilities to estimate the
individual-level reproductive number.
}
\details{
This function is meant to be called by \code{\link{estimateR}}
which estimates the individual-level, time-level, and average reproductive numbers, 
but it can also be run directly.
}
\seealso{
\code{\link{estimateR}} \code{\link{estimateRt}} \code{\link{estimateRtAvg}}
}
