% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amiralandmarks-io.R
\name{read.landmarks}
\alias{read.landmarks}
\alias{write.landmarks}
\title{Generic functions to read/write landmarks in any supported format}
\usage{
read.landmarks(f, ...)

write.landmarks(x, file, format = "amiralandmarks", ext = NULL,
  Force = FALSE, MakeDir = TRUE, ...)
}
\arguments{
\item{f}{Path to a file (can also be a URL)}

\item{...}{Additional arguments passed on to format specific functions}

\item{x}{The landmarks object to write. Can also be a plain \code{matrix} or 
\code{data.frame}.}

\item{file}{The path to the output file. If this does not end in an extension
like \code{.landmarksAscii}, then one will be added based on the value of 
the \code{ext} argument.}

\item{format}{Character vector specifying output format. Defaults to 
\code{"amiralandmarks"}. Partial matching is used (e.g. amira is
sufficient).}

\item{ext}{Optional character vector specifying a new or non-standard 
extension to use for output file, including the period (e.g. 
\code{ext='.am'}). When \code{ext=NULL}, the default, the default extension
for the selected \code{format} will be added if \code{f} does not have an 
extension. When \code{ext=NA}, the extension will not be modified and no 
extension will be appended if \code{f} does not have one.}

\item{Force}{Whether to overwrite an existing file}

\item{MakeDir}{Whether to create directory implied by \code{file} argument.}
}
\value{
for \code{read.landmarks} a matrix or list of additional class 
  landmarks, where the rownames specify the names of each landmark if 
  available.

For \code{write.landmarks} the path to the written file, invisibly.
}
\description{
Generic functions to read/write landmarks in any supported format
}
\details{
Presently the supported formats are \itemize{
  
  \item Amira
  
  \item CMTK
  
  \item Fiji (see \url{http://fiji.sc/Name_Landmarks_and_Register}) }
  
  See examples section for how to produce a listing of all currently 
  available formats with \code{fileformats}.
}
\section{Paired landmarks}{
 Only the amiralandmarks format supports the use of
  paired landmarks
}
\examples{
## Listing of supported fileformats for landmarks
fileformats(class = 'landmarks', rval = "info")

## round trip tests
m=matrix(rnorm(6), ncol=3)
rownames(m)=c("nose", "ear")
f=write.landmarks(m, file='knee', format='cmtk')
read.landmarks(f)

# write in amira format which does not support named landmarks
f2=write.landmarks(m, file='knee', format='amira')
read.landmarks(f2)

# clean up
unlink(c(f,f2))
}
\seealso{
\code{\link{fileformats}}
}

