% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmtkreg.R
\name{plot3d.cmtkreg}
\alias{plot3d.cmtkreg}
\title{Plot the domain of a CMTK registration}
\usage{
\method{plot3d}{cmtkreg}(x, ...)
}
\arguments{
\item{x}{A cmtk registration (the path to the registration folder on disk) or
the resulting of reading one in with \code{\link{read.cmtkreg}}.}

\item{...}{Additional arguments passed to \code{\link[rgl]{plot3d}}}
}
\description{
Plot the domain of a CMTK registration
}
\examples{
\dontrun{
testdatadir=system.file("tests/testthat/testdata/cmtk", package="nat")
regpath=file.path(testdatadir,'FCWB_JFRC2_01_warp_level-01.list/')
plot3d(cmtkreg(regpath))

# or read registration into memory if you want to work with it
reg=read.cmtkreg(regpath)
# nb calling plot3d.cmtkreg directly (rather than using the generic plot3d) 
# is considered bad style but read.cmtkreg returns a plain list 
# so method dispatch will fail
nat:::plot3d.cmtkreg(reg)
}
}
\seealso{
\code{\link{cmtkreg}}, \code{\link{read.cmtkreg}},
  \code{\link[rgl]{plot3d}}
}
