% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngraph.R
\name{prune_vertices}
\alias{prune_vertices}
\alias{prune_edges}
\title{Prune selected vertices or edges from a neuron}
\usage{
prune_vertices(x, verticestoprune, invert = FALSE, ...)

prune_edges(x, edges, invert = FALSE, ...)
}
\arguments{
\item{x}{A \code{\link{neuron}} to prune. This can be any object that can be 
converted by \code{\link{as.ngraph}} --- see details.}

\item{verticestoprune}{An integer vector describing which vertices to remove.}

\item{invert}{Whether to keep vertices rather than dropping them (default 
FALSE).}

\item{...}{Additional arguments passed to \code{\link{as.neuron.ngraph}}}

\item{edges}{The edges to remove. One of i) an Nx2 matrix, each row
specifying a single edge defined by its \bold{raw} edge id, ii) an integer
vector defining a \emph{path} of raw vertex ids or iii) an \code{igraph.es}
edge sequence --- see detaiuls and the \code{P} and \code{path} arguments
of \code{igraph::\link[igraph]{E}}.}
}
\value{
A pruned \code{neuron}
}
\description{
\code{prune_vertices} removes vertices from a neuron

\code{prune_edges} removes edges (and any unreferenced vertices)
}
\details{
These are relatively low-level functions and you will probably want 
  to use \code{\link{subset.neuron}} or \code{\link{prune.neuron}} and 
  friends in many cases.
  
  Note that \code{prune_vertices} and \code{prune_edges} both use \bold{raw} 
  vertex ids to specify the vertices/edges to be removed. If you want to use 
  the id in the PointNo field, then you must translate yourself (see 
  examples).
  
  Both \code{prune_vertices} and \code{prune_edges} first convert their input
  \code{x} to the \code{\link{ngraph}} representation of the neuron befor 
  removing points. The input \code{x} can therefore be in any form compatible
  with \code{\link{as.ngraph}} including an existing \code{ngraph}. There is 
  an additional requirement that the input must be compatible with 
  \code{\link{xyzmatrix}} if \code{invert=TRUE}.
  
  Note that the \code{edges} argument of \code{prune_edges} must specify a 
  path traversing a set of vertices in a valid order. However if the input is
  a matrix or vector the direction of each individual edge in this path is
  ignored. So if your neuron has edges 2->1 2->3 3->4 then an edge sequence
  1:3 would successfully delete 2 edges.
}
\examples{
n=prune_vertices(Cell07PNs[[1]], 1:25)
# original neuron
plot(Cell07PNs[[1]])
# with pruned neuron superimposed
plot(n, col='green', lwd=3, add=TRUE)

# use the PointNo field (= the original id from an SWC file)
n2=prune_vertices(n, match(26:30, n$d$PointNo))
y=prune_edges(Cell07PNs[[1]], edges=1:25)

# remove the spine of a neuron
spine_ids=spine(Cell07PNs[[1]], rval='ids')
pruned=prune_edges(Cell07PNs[[1]], spine_ids)

# NB this is subtly different from this, which removes vertices along the
# spine *even* if they are part of an edge that is outside the spine.
pruned2=prune_vertices(Cell07PNs[[1]], spine_ids)
}
\seealso{
\code{\link{as.neuron.ngraph}}, \code{\link{subset.neuron}}, 
  \code{\link{prune.neuron}}
}
