% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neuron-plot.R
\name{nview3d}
\alias{nview3d}
\title{Set the 3D viewpoint of an RGL window using anatomical terms}
\usage{
nview3d(
  viewpoint = c("frontal", "anterior", "dorsal", "ventral", "posterior", "left",
    "right", "oblique_right", "oblique_left"),
  FOV = 0,
  extramat = NULL,
  ...
)
}
\arguments{
\item{viewpoint}{Character vector specifying viewpoint}

\item{FOV}{The Field of View (defaults to 0 => orthographic projection) (see
\code{\link[rgl]{par3d}} for details).}

\item{extramat}{An optional extra transformation matrix to be applied after
the one implied by the viewpoint argument.}

\item{...}{additional arguments passed to \code{\link[rgl]{par3d}}}
}
\description{
Set the 3D viewpoint of an RGL window using anatomical terms
}
\examples{
\donttest{
plot3d(kcs20, soma=TRUE)
nview3d('frontal')
nview3d('ant')
nview3d()
nview3d('posterior')
nview3d('oblique_right')
# a slightly oblique frontal view
nview3d('frontal', extramat=rotationMatrix(pi/10, 1, 1, 0))
}
}
\seealso{
\code{\link{nopen3d}}, \code{\link{view3d}}
}
