% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_repos.R
\name{add_reg_folders}
\alias{add_reg_folders}
\alias{extra_reg_folders}
\title{Set or list local folders containing registrations for nat.templatebrains}
\usage{
add_reg_folders(dir = extra_reg_folders(), first = TRUE)

extra_reg_folders(full.names = TRUE)
}
\arguments{
\item{dir}{Path to one or more folders containing registrations. Default
value will scan for registration folders in a standard location. (Please
see \bold{Details} and \bold{File layout} sections)}

\item{first}{Whether the new folder should be added to the start (default) or
end of the search list.}

\item{full.names}{Whether to list full path to registration folders}
}
\description{
\code{add_reg_folders} sets
  options('nat.templatebrains.regdirs') appropriately so that registrations
  can be found by e.g. \code{xform_brain}.

\code{extra_reg_folders} lists extra registration folders
  present in standard location
}
\details{
When \code{dir} is unset then it will default to the value of
  \code{extra_reg_folders()} i.e. any folders / cloned repositories in the
  standard location
}
\section{File layout}{
 You must pass a folder containing one or more
  registrations, not the registration folder itself. So if you have this
  situation on disk \itemize{

  \item myregistrations/

  \item myregistrations/reg1.list

  \item myregistrations/reg2.list

  }

  you should write \code{add_reg_folders("/path/to/myregistrations")}
}

\examples{

\dontrun{
  add_reg_folders("myextraregistrations")
}
# adding a non-existent folder will generate an error
tools::assertError(add_reg_folders(tempfile()))
}
