% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\name{emr_track.ls}
\alias{emr_track.ls}
\alias{emr_track.global.ls}
\alias{emr_track.user.ls}
\alias{emr_track.logical.ls}
\title{Returns a list of track names}
\usage{
emr_track.ls(
  ...,
  db_id = NULL,
  ignore.case = FALSE,
  perl = FALSE,
  fixed = FALSE,
  useBytes = FALSE
)

emr_track.global.ls(
  ...,
  ignore.case = FALSE,
  perl = FALSE,
  fixed = FALSE,
  useBytes = FALSE
)

emr_track.user.ls(
  ...,
  ignore.case = FALSE,
  perl = FALSE,
  fixed = FALSE,
  useBytes = FALSE
)

emr_track.logical.ls(
  ...,
  ignore.case = FALSE,
  perl = FALSE,
  fixed = FALSE,
  useBytes = FALSE
)
}
\arguments{
\item{...}{these arguments are of either form 'pattern' or 'attribute =
pattern'}

\item{db_id}{db dir string (path), one of the paths supplied in emr_db.connect. If NULL - all track names would be
returned.}

\item{ignore.case, perl, fixed, useBytes}{see 'grep'}
}
\value{
An array that contains the names of tracks that match the supplied
patterns.
}
\description{
Returns a list of track names in the database.
}
\details{
'emr_track.ls' returns a list of all tracks (global and user) in the
database that match the pattern (see 'grep'). If called without any
arguments all tracks are returned.

If pattern is specified without a track attribute (i.e. in the form of
'pattern') then filtering is applied to the track names. If pattern is
supplied with a track attribute (i.e. in the form of 'name = pattern') then
track attribute is matched against the pattern.

Multiple patterns are applied one after another. The resulted list of tracks
should match all the patterns.

If \code{db_id} parameter is set, only tracks within the specific db would be shown.
Note that tracks which were overridden by other databases would not be shown, even if
their files exist within the database. See \code{emr_db.connect} for more details.

'emr_track.global.ls', 'emr_track.user.ls', 'emr_track.logical.ls' work similarly to
'emr_track.ls' but instead of returning all track names, each of them
returns either global, local or logical tracks accordingly.
}
\examples{

emr_db.init_examples()

# get all track names
emr_track.ls()

# get track names that match the pattern "den*"
emr_track.ls("den*")

emr_track.attr.set("sparse_track", "gender", "female")
emr_track.attr.set("dense_track", "gender", "male")
emr_track.ls(gender = "")
emr_track.ls(gender = "female")
emr_track.ls(gender = "^male")
}
\seealso{
\code{\link{grep}}, \code{\link{emr_db.init}},
\code{\link{emr_track.exists}}
}
\keyword{~ls}
\keyword{~track}
\keyword{~tracks}
