% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tls.R
\name{write_cert}
\alias{write_cert}
\title{Generate Self-Signed Certificate and Key}
\usage{
write_cert(cn = "localhost", valid = "20301231235959")
}
\arguments{
\item{cn}{[default 'localhost'] character issuer common name (CN) for the
certificate. This can be either a hostname or an IP address, but must match
the actual server URL as client authentication will depend on it.}

\item{valid}{[default '20301231235959'] character \sQuote{not after}
date-time in \sQuote{yyyymmddhhmmss} format. The certificate is not valid
after this time.}
}
\value{
A list of length 2, comprising \code{$server} and \code{$client}.
  These may be passed directly to the relevant argument of
  \code{\link{tls_config}}.
}
\description{
Generate self-signed x509 certificate and 4096 bit RSA private/public key
pair for use with authenticated, encrypted TLS communications.
}
\details{
Note that it can take a second or two for the key and certificate to be
generated.
}
\examples{

if (interactive()) {
# Only run examples in interactive R sessions

cert <- write_cert(cn = "127.0.0.1")
ser <- tls_config(server = cert$server)
cli <- tls_config(client = cert$client)

s <- socket(listen = "tls+tcp://127.0.0.1:5555", tls = ser)
s1 <- socket(dial = "tls+tcp://127.0.0.1:5555", tls = cli)

# secure TLS connection established

close(s1)
close(s)

cert

}

}
