% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sync.R
\name{lock}
\alias{lock}
\alias{unlock}
\title{Lock / Unlock a Socket}
\usage{
lock(socket, cv = NULL)

unlock(socket)
}
\arguments{
\item{socket}{a Socket.}

\item{cv}{(optional) a \sQuote{conditionVariable}. If supplied, the socket is
locked only whilst the condition variable is an odd value. This is designed
to allow an initial connection, as well as subsequent re-connections after
a connection has ended, if the conditon variable is also registered with
\code{\link{pipe_notify}} for both add and remove pipe events.}
}
\value{
Invisibly, zero on success (will otherwise error).
}
\description{
Prevents further pipe connections from being established at a Socket. If a
socket is locked, new pipe connections are closed before they can be added to
the socket.
}
\examples{
s <- socket("bus", listen = "inproc://nanolock")
s1 <- socket("bus", dial = "inproc://nanolock")
lock(s)
s2 <- socket("bus", dial = "inproc://nanolock")

send(s, "test")
recv(s1)
recv(s2)

unlock(s)
s3 <- socket("bus", dial = "inproc://nanolock")
send(s, "test")
recv(s1)
recv(s3)

close(s)
close(s1)
close(s2)
close(s3)

}
