% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncurl.R
\name{ncurl_session}
\alias{ncurl_session}
\alias{transact}
\title{ncurl Session}
\usage{
ncurl_session(
  url,
  convert = TRUE,
  method = NULL,
  headers = NULL,
  data = NULL,
  response = NULL,
  timeout = NULL,
  tls = NULL
)

transact(session)
}
\arguments{
\item{url}{the URL address.}

\item{convert}{[default TRUE] logical value whether to attempt conversion of
the received raw bytes to a character vector. Set to FALSE if downloading
non-text data.}

\item{method}{(optional) the HTTP method (defaults to 'GET' if not specified).}

\item{headers}{(optional) a named character vector specifying the HTTP
request headers, for example: \cr
\code{c(Authorization = "Bearer APIKEY", `Content-Type` = "text/plain")}
\cr A non-character or non-named vector will be ignored.}

\item{data}{(optional) character request data to be submitted.}

\item{response}{(optional) a character vector specifying the response headers
to return e.g. \code{c("date", "server")}. These are case-insensitive and
will return NULL if not present. A non-character vector will be ignored.}

\item{timeout}{(optional) integer value in milliseconds after which the
connection and subsequent transact attempts time out.}

\item{tls}{(optional) applicable to secure HTTPS sites only, a client TLS
Configuration object created by \code{\link{tls_config}}. If missing or
NULL, certificates are not validated.}

\item{session}{an 'ncurlSession' object.}
}
\value{
For \code{ncurl_session}: an 'ncurlSession' object if successful, or
    else an 'errorValue'.

For \code{transact}: a named list of 3 elements:
    \itemize{
    \item \code{$status} - integer HTTP repsonse status code (200 - OK).
    Use \code{\link{status_code}} for a translation of the meaning.
    \item \code{$headers} - named list of response headers (if specified in
    the session), or NULL otherwise. If the status code is within the 300
    range, i.e. a redirect, the response header 'Location' is automatically
    appended to return the redirect address.
    \item \code{$data} - the response body as a character string (if
    'convert = TRUE' was specified for the session), which may be further
    parsed as html, json, xml etc. as required, or else a raw byte vector,
    which may be saved as a file using \code{\link{writeBin}}.
    }
}
\description{
nano cURL - a minimalist http(s) client. A session encapsulates a connection,
    along with all related parameters, and may be used to return data
    multiple times by repeatedly calling \code{transact}, which transacts
    once over the connection.
}
\examples{
s <- ncurl_session("https://www.r-project.org/", response = "date", timeout = 2000L)
s
if (!is_error_value(s)) transact(s)
if (!is_error_value(s)) close(s)

}
\seealso{
\code{\link{ncurl_aio}} for asynchronous http requests.
}
