% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sendrecv.R
\name{recv}
\alias{recv}
\title{Receive}
\usage{
recv(
  con,
  mode = c("serial", "character", "complex", "double", "integer", "logical", "numeric",
    "raw"),
  block = NULL,
  keep.raw = FALSE,
  n = 65536L
)
}
\arguments{
\item{con}{a Socket, Context or Stream.}

\item{mode}{[default 'serial'] mode of vector to be received - one of 'serial',
'character', 'complex', 'double', 'integer', 'logical', 'numeric', or 'raw'.
The default 'serial' means a serialised R object, for the other modes,
the raw vector received will be converted into the respective mode.
For Streams, 'serial' is not an option and the default is 'character'.
Alternatively, for performance, specify an integer position in the vector
of choices e.g. 1L for 'serial', 2L for 'character' etc.}

\item{block}{[default NULL] which applies the connection default (see section
'Blocking' below). Specify logical TRUE to block until successful or FALSE
to return immediately even if unsuccessful (e.g. if no connection is
available), or else an integer value specifying the maximum time to block
in milliseconds, after which the operation will time out.}

\item{keep.raw}{[default FALSE] logical flag whether to keep and return the
received raw vector along with the converted data. Supplying a non-logical
value will error.}

\item{n}{[default 65536L] applicable to Streams only, the maximum number of
bytes to receive. Can be an over-estimate, but note that a buffer of this
size is reserved.}
}
\value{
Depending on the value of 'keep.raw': if TRUE, a named list of 2
    elements - \code{$raw} containing the received raw vector and \code{$data}
    containing the converted data, or if FALSE, the converted data.
}
\description{
Receive data over a connection (Socket, Context or Stream).
}
\details{
In case of an error, an integer 'errorValue' is returned (to be
    distiguishable from an integer message value). This can be verified using
    \code{\link{is_error_value}}.

    If the raw message was successfully received but an error occurred in
    unserialisation or data conversion (for example if the incorrect mode was
    specified), the received raw vector will always be returned to allow for
    the data to be recovered.
}
\section{Blocking}{


    For Sockets: the default behaviour is non-blocking with \code{block = FALSE}.
    This will return immediately with an error if no messages are available.

    For Contexts and Streams: the default behaviour is blocking with \code{block = TRUE}.
    This will wait until a message is received. Set a timeout in this case to
    ensure that the function returns under all scenarios. As the underlying
    implementation uses an asynchronous send with a wait, it is recommended
    to set a positive integer value for \code{block} rather than FALSE.
}

\examples{
s1 <- socket("pair", listen = "inproc://nanonext")
s2 <- socket("pair", dial = "inproc://nanonext")

send(s1, data.frame(a = 1, b = 2))
res <- recv(s2)
res
send(s1, data.frame(a = 1, b = 2))
recv(s2, keep.raw = TRUE)

send(s1, c(1.1, 2.2, 3.3), mode = "raw")
res <- recv(s2, mode = "double", block = 100, keep.raw = TRUE)
res
send(s1, "example message", mode = "raw")
recv(s2, mode = "character")

close(s1)
close(s2)

req <- socket("req", listen = "inproc://nanonext")
rep <- socket("rep", dial = "inproc://nanonext")

ctxq <- context(req)
ctxp <- context(rep)
send(ctxq, data.frame(a = 1, b = 2), block = 100)
recv(ctxp, block = 100)

send(ctxq, c(1.1, 2.2, 3.3), mode = "raw", block = 100)
recv(ctxp, mode = "double", block = 100)

close(req)
close(rep)

}
