% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sendrecv.R
\name{recv}
\alias{recv}
\alias{recv.nanoSocket}
\alias{recv.nanoContext}
\alias{recv.nanoStream}
\title{Receive}
\usage{
recv(
  con,
  mode = c("serial", "character", "complex", "double", "integer", "logical", "numeric",
    "raw"),
  block,
  keep.raw = TRUE,
  ...,
  n = 65536L
)

\method{recv}{nanoSocket}(
  con,
  mode = c("serial", "character", "complex", "double", "integer", "logical", "numeric",
    "raw"),
  block = FALSE,
  keep.raw = TRUE,
  ...
)

\method{recv}{nanoContext}(
  con,
  mode = c("serial", "character", "complex", "double", "integer", "logical", "numeric",
    "raw"),
  block = TRUE,
  keep.raw = TRUE,
  ...
)

\method{recv}{nanoStream}(
  con,
  mode = c("character", "complex", "double", "integer", "logical", "numeric", "raw"),
  block = TRUE,
  keep.raw = TRUE,
  n = 65536L,
  ...
)
}
\arguments{
\item{con}{a Socket, Context or Stream.}

\item{mode}{<Sockets and Contexts> [default 'serial'] mode of vector to be
received - one of 'serial', 'character', 'complex', 'double', 'integer',
'logical', 'numeric', or 'raw'. The default 'serial' means a serialised
R object, for the other modes, the raw vector received will be converted
into the respective mode.
<Streams> [default 'character'] note that 'serial' is not an option for
Streams.}

\item{block}{logical TRUE to block until successful or FALSE to return
immediately even if unsuccessful  (e.g. if no messages are available),
or else an integer value specifying the maximum time to block in
milliseconds, after which the operation will time out.}

\item{keep.raw}{[default TRUE] logical flag whether to keep the received raw
vector (useful for verification e.g. via hashing). If FALSE, will return
the converted data only.}

\item{...}{currently unused.}

\item{n}{<Streams> [default 65536L] the maximum number of bytes to receive.
Can be an over-estimate, but note that a buffer of this size is reserved.}
}
\value{
Named list of 2 elements: 'raw' containing the received raw vector
    and 'data' containing the converted object, or else the converted object
    if 'keep.raw' is set to FALSE.
}
\description{
Receive data over a connection (Socket, Context or Stream).
}
\details{
In case of an error, an integer 'errorValue' is returned (to be
    distiguishable from an integer message value). This can be verified using
    \code{\link{is_error_value}}.

    If the raw data was successfully received but an error occurred in
    unserialisation or data conversion (for example if the incorrect mode was
    specified), the received raw vector will always be returned to allow for
    the data to be recovered.
}
\section{Blocking}{


    For Sockets: the default behaviour is non-blocking with \code{block = FALSE}.
    This will return immediately with an error if no messages are available.

    For Contexts and Streams: the default behaviour is blocking with \code{block = TRUE}.
    This will wait until a message is received. Set a timeout in this case to
    ensure that the function returns under all scenarios. As the underlying
    implementation uses an asynchronous send with a wait, it is recommended
    to set a positive integer value for \code{block} rather than FALSE.
}

\examples{
s1 <- socket("bus", listen = "inproc://nanonext")
s2 <- socket("bus", dial = "inproc://nanonext")

send(s1, data.frame(a = 1, b = 2))
res <- recv(s2)
res
send(s1, data.frame(a = 1, b = 2), echo = FALSE)
recv(s2, keep.raw = FALSE)

send(s1, c(1.1, 2.2, 3.3), mode = "raw")
res <- recv(s2, mode = "double", block = 100)
res
send(s1, "example message", mode = "raw", echo = FALSE)
recv(s2, mode = "character", keep.raw = FALSE)

close(s1)
close(s2)

req <- socket("req", listen = "inproc://nanonext")
rep <- socket("rep", dial = "inproc://nanonext")

ctxq <- context(req)
ctxp <- context(rep)
send(ctxq, data.frame(a = 1, b = 2), block = 100)
recv(ctxp, block = 100)

send(ctxq, c(1.1, 2.2, 3.3), mode = "raw", block = 100)
recv(ctxp, mode = "double", block = 100)

close(req)
close(rep)

}
