% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sendrecv.R
\name{recv_vec}
\alias{recv_vec}
\title{Receive Vector}
\usage{
recv_vec(
  socket,
  mode = c("character", "complex", "double", "integer", "logical", "numeric", "raw"),
  block = FALSE,
  keep.raw = TRUE
)
}
\arguments{
\item{socket}{a Socket.}

\item{mode}{[default 'character'] mode of vector to be read - one of
'character', 'complex', 'double', 'integer', 'logical', 'numeric', 'raw'.}

\item{block}{[default FALSE] logical flag whether to block until successful
or return immediately even if unsuccessful (e.g. nothing to receive).}

\item{keep.raw}{[default TRUE] TRUE to keep the received raw vector (useful
for verification e.g. via hashing, or in case of an error in decoding to
'mode'). If FALSE, will return the decoded object only.}
}
\value{
Named list of 2 elements: 'raw' containing the received raw vector
    and 'data' containing the vector decoded to the type 'mode', or else the
    decoded vector of type 'mode' if keep.raw is set to FALSE.
}
\description{
Receive vector data over a Socket. The counterpart to \code{\link{send_vec}},
    data will be re-created from the raw vector according to the specified
    mode. Can be used when interfacing with external programs.
}
\examples{
s1 <- socket("bus", listen = "inproc://nanonext")
s2 <- socket("bus", dial = "inproc://nanonext")

send_vec(s1, c(1.1, 2.2, 3.3))
res <- recv_vec(s2, "double")
res

send_vec(s1, "example test", echo = FALSE)
recv_vec(s2, "character", keep.raw = FALSE)

close(s1)
close(s2)

}
