% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{fill_missing}
\alias{fill_missing}
\alias{fill_missing,spec_tbl_df-method}
\alias{fill_missing,tbl_df-method}
\title{Fill feature value if missing from element-feature pairs}
\usage{
fill_missing(.data, .element, .feature, .value, fill_with)

\S4method{fill_missing}{spec_tbl_df}(.data, .element, .feature, .value, fill_with)

\S4method{fill_missing}{tbl_df}(.data, .element, .feature, .value, fill_with)
}
\arguments{
\item{.data}{A `tbl` formatted as | <element> | <feature> | <value> | <...> |}

\item{.element}{The name of the element column}

\item{.feature}{The name of the feature/gene column}

\item{.value}{The name of the feature/gene value column}

\item{fill_with}{A numerical value with which fill the mssing data points}
}
\value{
A `tbl` non-sparse value

A `tbl` with filled abundance

A `tbl` with filled abundance
}
\description{
fill_missing() takes as imput a `tbl` formatted as | <element> | <feature> | <value> | <...> | and returns a `tbl` with an edditional adjusted value column. This method uses scaled counts if present.
}
\details{
\lifecycle{maturing}

This function fills the value of missing element-feature pair using the median of the element group defined by the formula
}
\examples{

fill_missing(mtcars_tidy, car_model, feature, value, fill_with = 0)


}
