% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadow-verifiers.R
\name{is_shadow}
\alias{is_shadow}
\alias{is_nabular}
\title{Test if input is or are shadow variables}
\usage{
is_shadow(x)

is_nabular(x)
}
\arguments{
\item{x}{a vector or data.frame}
}
\value{
logical vector of length 1
}
\description{
Shadow matrix or "nabular" data is a useful way to store missing data to
facilitate missing data visualisation. This data can be created using
\code{bind_shadow}. \code{is_shadow} tells us if there are any shadow variables.
}
\examples{

aq_sh <- as_shadow(airquality)
aq_bind <- bind_shadow(airquality)

is_shadow(aq_sh)
is_shadow(airquality)
is_shadow(aq_bind)
is_nabular(aq_bind)

}
