% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naaccr_factor.R
\name{naaccr_factor}
\alias{naaccr_factor}
\title{Replace NAACCR codes with understandable factors}
\usage{
naaccr_factor(x, field, keep_unknown = FALSE, ...)
}
\arguments{
\item{x}{Vector (usually character) of codes.}

\item{field}{String giving the XML name of the NAACCR field to code.}

\item{keep_unknown}{Logical indicating whether values of "unknown" should be
a level in the factor or \code{NA}.}

\item{...}{Additional arguments passed onto \code{\link[base]{factor}}.}
}
\value{
A \code{factor} vector version of \code{x}. The levels are short
  descriptions instead of the basic NAACCR codes. Codes which stood for
  "unknown" with no further information are replaced with \code{NA}.

  If \code{field} names a text or site-specific field, \code{x} will be
  returned unchanged with a warning.
}
\description{
Replace NAACCR codes with understandable factors
}
\examples{
  naaccr_factor(c("20", "43", "99"), "radRegionalRxModality")
  naaccr_factor(c("USA", "GER", "XEN"), "addrAtDxCountry")
  # Default: NA for unknowns,
  naaccr_factor(c("1", "8", "9"), "tumorGrowthPattern")
  naaccr_factor(c("1", "8", "9"), "tumorGrowthPattern", keep_unknown = TRUE)
}
