% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{plotVenn}
\alias{plotVenn}
\title{Create Venn diagram using the nVenn algorithm.}
\usage{
plotVenn(
  sets,
  nVennObj = NULL,
  nCycles = 7000,
  sNames = NULL,
  showPlot = T,
  ...
)
}
\arguments{
\item{sets}{List of lists with the input sets.}

\item{nVennObj}{Object returned from previous run. If provided, the function will improve the
diagram by running more cycles on the previous result. If nVennObj is provided, do not feed
additional input lists, as they will be ignored}

\item{nCycles}{Number of cycles for the simulation. For up to 4 sets, the default number of 7000
should be enough. Even for more complex scenarios, it may be better to run the function repeatedly,
as a large number of cycles may take up too many resources.}

\item{sNames}{List of set names, in the same order as the input lists. If the input has tables or
data frames and the name exists, it will select the corresponding column.}

\item{showPlot}{Show the result in the graphic device.}

\item{...}{Options for `showSVG`
If input lists have names, those names will be used for the legend. If not, names can be
provided with \code{sNames}.}
}
\value{
nVennObj with the result of the simulation. As a side effect, The result can be drawn in the
graphical device.
}
\description{
This algorithm is based on a simulation
that compacts the figure. If the resulting diagram is not compact enough, the simulation can be tweaked
in two ways: changing the number of simulation cycles (`nCycles`) and executing this function repeatedly.
}
\examples{
set1 <- list(set1 = c('a', 'b', 'c'))
set2 <- list(set2 = c('e', 'f', 'c'))
set3 <- list(set3 = c('c', 'b', 'e'))
myNV <- plotVenn(list(set1, set2, set3), sNames=c("One", "Two", "Three"))
showSVG(myNV, opacity=0.2)
}
