% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.R
\name{mc_prep_solar_tz}
\alias{mc_prep_solar_tz}
\title{Set solar time offset against UTC time}
\usage{
mc_prep_solar_tz(data)
}
\arguments{
\item{data}{myClim object see \link{myClim-package}}
}
\value{
myClim object in the same format as input, with \code{tz_offset} filled in locality metadata
}
\description{
This function calculates the offset against UTC on the locality to get the solar time.
This is based on coordinates (longitude). If longitude is not provided, then not working.
}
\details{
myClim library presumes the data in UTC by default. This function require at least longitude provided in locality
metadata slot \code{lon_wgs84}. If longitude is not provided, function does not work. Coordinates of locality can be provided
e.g. during data reading see \code{\link[=mc_read_data]{mc_read_data()}} or ex post with \code{\link[=mc_prep_meta_locality]{mc_prep_meta_locality()}} function.

TZ offset in minutes is calculated as \code{longitude / 180 * 12 * 60}.
}
\examples{
data_solar <- mc_prep_solar_tz(mc_data_example_clean)
}
