% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mxsem_group_by.R
\name{summarize_multi_group_model}
\alias{summarize_multi_group_model}
\title{summarize_multi_group_model}
\usage{
summarize_multi_group_model(multi_group_model)
}
\arguments{
\item{multi_group_model}{multi group model created with mxsem_group_by}
}
\value{
list with goup specific parameters and common parameters
}
\description{
summarize the results of a multi group model created with mxsem_group_by
}
\examples{
# THE FOLLOWING EXAMPLE IS ADAPTED FROM
# https://openmx.ssri.psu.edu/docs/OpenMx/latest/_static/Rdoc/mxModel.html
library(mxsem)

model <- 'spatial =~ visual + cubes + paper
          verbal  =~ general + paragrap + sentence
          math    =~ numeric + series + arithmet'

mg_model <- mxsem(model = model,
                  data  = OpenMx::HS.ability.data) |>
  # we want separate models for all combinations of grades and schools:
  mxsem_group_by(grouping_variables = "school") |>
  mxTryHard()

# let's summarize the results:
summarize_multi_group_model(mg_model)
}
