% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_starting_values.R
\name{set_starting_values}
\alias{set_starting_values}
\title{set_starting_values}
\usage{
set_starting_values(mx_model, values)
}
\arguments{
\item{mx_model}{model of class mxModel}

\item{values}{vector with labeled parameter values}
}
\value{
mxModel with changed parameter values
}
\description{
set the starting values of an OpenMx model. This is just an interface to
omxSetParameters.
}
\examples{
library(mxsem)

model <- '
  # latent variable definitions
     ind60 =~ x1 + x2 + x3
     dem60 =~ y1 + a1*y2 + b*y3 + c1*y4
     dem65 =~ y5 + a2*y6 + b*y7 + c2*y8

  # regressions
    dem60 ~ ind60
    dem65 ~ ind60 + dem60

  # residual correlations
    y1 ~~ y5
    y2 ~~ y4 + y6
    y3 ~~ y7
    y4 ~~ y8
    y6 ~~ y8
'

fit <- mxsem(model = model,
            data  = OpenMx::Bollen) |>
  set_starting_values(values = c("a1" = .4, "c1" = .6)) |>
  mxTryHard()
}
