% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvtb_covex.R
\name{mvtb.covex}
\alias{mvtb.covex}
\title{Estimate the covariance explained matrix}
\usage{
mvtb.covex(object, Y, X, n.trees = NULL, iter.details = FALSE)
}
\arguments{
\item{object}{an object of class \code{mvtb}}

\item{Y}{vector, matrix, or data.frame for outcome variables with no missing values. To easily compare influences across outcomes and for numerical stability, outcome variables should be scaled to have unit variance.}

\item{X}{vector, matrix, or data.frame of predictors. For best performance, continuous predictors should be scaled to have unit variance. Categorical variables should converted to factors.}

\item{n.trees}{number of trees to use. Defaults to the minimum number of trees by CV, test, or training error}

\item{iter.details}{\code{TRUE/FALSE}. Return the loss, relative loss, and selected predictors at each iteration as a list}
}
\value{
Covariance explained matrix, or a list if \code{iter.details} is \code{TRUE}.
}
\description{
Estimate the covariance explained matrix
}

