% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvtb_plots.R
\name{mvtb.perspec}
\alias{mvtb.perspec}
\title{Perspective plot for 2 predictors and 1 response.}
\usage{
mvtb.perspec(object, response.no = 1, predictor.no = 1:2, n.trees = NULL,
  phi = 15, theta = -55, r = sqrt(10), d = 3, xlab = NULL,
  ylab = NULL, zlab = NULL, ticktype = "detailed", ...)
}
\arguments{
\item{object}{\code{mvtb} output object}

\item{response.no}{index of the response variable}

\item{predictor.no}{vector containing indices of the predictor variables to plot}

\item{n.trees}{desired number of trees. Defaults to the minimum number of trees by CV, test, or training error}

\item{phi}{angle of viewing direction. See \code{?persp}.}

\item{theta}{angle of viewing direction See \code{?persp}.}

\item{r}{distance from eye to center. See \code{?persp}.}

\item{d}{strength of perspective. See \code{?persp}.}

\item{xlab, }{title for x axis, must be character strings.}

\item{ylab, }{title for y axis, must be character strings.}

\item{zlab, }{title for z axis, must be character strings.}

\item{ticktype}{'detailed' gives axis points. See \code{?persp} for other options.}

\item{...}{extra arguments are passed to persp. See \code{?persp}}
}
\value{
Function returns a plot.
}
\description{
This is a plot of the model implied function of 2 predictors averaged over the other predictors
included in the model. This is called a partial dependence plot.
As an alternative to the perspective (3D) plot, a 2D heat plot can be obtained directly
using \code{?plot.gbm}.
}
\seealso{
\code{plot.gbm}, \code{plot.mvtb}, \code{mvtb.heat}
}

