\name{mvb.sys.parent}
\alias{mvb.sys.parent}
\alias{mvb.sys.nframe}
\alias{mvb.parent.frame}
\alias{mvb.match.call}
\alias{mvb.nargs}
\alias{mvb.sys.call}
\alias{mvb.sys.function}
\alias{mvb.sys.on.exit}
\title{Functions to Access the Function Call Stack}
\description{These functions are "do what I mean, not what I say" equivalents of the corresponding system functions. The system functions can behave strangely when called in strange ways (primarily inside \code{eval} calls). The \code{mvb} equivalents behave in a more predictable fashion.}
\usage{
mvb.sys.parent(n=1)
mvb.sys.nframe()
mvb.parent.frame(n=1)
mvb.match.call(definition = sys.function(mvb.sys.parent()),
    call = sys.call(mvb.sys.parent()),  expand.dots = TRUE)
mvb.nargs()
mvb.sys.call(which = 0)
mvb.sys.function(n)
mvb.sys.on.exit()
}
\arguments{
All as per the corresponding system functions, from whole helpfiles the following is taken:
\item{ which}{the frame number if non-negative, the number of generations to go back if negative. (See the Details section.)}
\item{ n}{the number of frame generations to go back.}
\item{ definition}{a function, by default the function from which \code{match.call} is called.}
\item{ call}{an unevaluated call to the function specified by \code{definition}, as generated by \code{call}.}
\item{ expand.dots}{logical. Should arguments matching \code{...} in the call be included or left as a \code{...} argument?}
}
\value{See the helpfiles for the system functions.}
\details{Sometimes \code{eval} is used to execute statements in another frame. If such statements include calls to the system versions of these routines, the results will probably not be what you want. In technical terms: the same environment will actually appear several times on the call stack (returned by \code{sys.frame()}) but with a different calling history each time. The \code{mvb.} equivalents look through \code{sys.frames()} for the first frame whose environment is identical to the environment they were called from, and base all conclusions on that first frame. To see how in detail, look at the most fundamental function: \code{mvb.sys.parent}.}
\examples{
ff.no.eval <- function() sys.nframe()
ff.no.eval() # 1
ff.system <- function() eval( quote( sys.nframe()), envir=sys.frame( sys.nframe()))
ff.system() # expect 1 as per ff.no.eval, get 3
ff.mvb <- function() eval( quote( mvb.sys.nframe()), envir=sys.frame( sys.nframe()))
ff.mvb() # 1
ff.no.eval <- function(...) sys.call()
ff.no.eval( 27, b=4) # ff.no.eval( 27, b=4)
ff.system <- function(...) eval( quote( sys.call()), envir=sys.frame( sys.nframe()))
ff.system( 27, b=4) # eval( expr, envir, enclos) !!!
ff.mvb <- function(...) eval( quote( mvb.sys.call()), envir=sys.frame( sys.nframe()))
ff.mvb( 27, b=4) # ff.mvb( 27, b=4)
}
\seealso{\code{\link{sys.parent}}, \code{\link{sys.nframe}}, \code{\link{parent.frame}}, \code{\link{match.call}}, \code{\link{nargs}}, \code{\link{sys.call}}, \code{\link{sys.function}}, \code{\link{sys.on.exit}}}
\author{Mark Bravington}
\keyword{programming}
