/*
 * Decompiled with CFR 0.152.
 */
package af.statguitoolkit.errorhandling;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.af.commons.Localizer;
import org.af.commons.errorhandling.ErrorDialog;
import org.af.commons.logging.ApplicationLog;
import org.af.commons.logging.LoggingSystem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;
import org.mutoss.MuTossControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorDialogSGTK
extends ErrorDialog {
    protected static Log logger = LogFactory.getLog(ErrorDialogSGTK.class);
    protected ApplicationLog al;
    protected JCheckBox chbAttachDf;

    public ErrorDialogSGTK(String msg, Object e, boolean fatal) {
        super(msg, e, fatal);
    }

    protected JPanel getOptionalPanel() {
        this.al = LoggingSystem.getInstance().getApplicationLog();
        JPanel p = new JPanel();
        String cols = "left:pref, 5dlu, pref:grow";
        String rows = "pref";
        FormLayout layout = new FormLayout(cols, rows);
        CellConstraints cc = new CellConstraints();
        p.setLayout((LayoutManager)layout);
        p.add((Component)new JLabel(Localizer.getInstance().getString("SGTK_ERRORHANDLING_INFORMDIALOG_ATTACHDATA")), cc.xy(1, 1));
        return p;
    }

    protected Hashtable<String, File> getAttachedFiles() throws IOException {
        Hashtable<String, File> files = new Hashtable<String, File>();
        files.put("sessioninfo", this.makeLogFile("session_info.txt", this.getRSessionInfo()));
        files.put("roptions", this.makeLogFile("r_options.txt", this.getROptions()));
        files.put("systeminfo", this.makeLogFile("system_info.txt", this.getSystemInfo()));
        files.put("log", this.getReadableLogFile());
        return files;
    }

    private String getSystemInfo() {
        return this.al.getSystemInfo();
    }

    private String getRPackageInfo() {
        return "";
    }

    private String getROptions() {
        return this.collapseStringArray(MuTossControl.getR().eval("options()").asRChar().getData());
    }

    private String getRSessionInfo() {
        return this.collapseStringArray(MuTossControl.getR().eval("sessionInfo()").asRChar().getData());
    }

    public File getReadableLogFile() {
        return new File(this.getReadableLogFileAppender().getFile());
    }

    public FileAppender getReadableLogFileAppender() {
        return (FileAppender)Logger.getRootLogger().getAppender("READABLE_FILE");
    }

    protected File makeLogFile(String fileName, String content) throws IOException {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File output = new File(tempDir, fileName);
        FileWriter fw = new FileWriter(output);
        fw.write(content);
        fw.close();
        return output;
    }

    private String collapseStringArray(String[] ss, String sep) {
        String result = "";
        for (String s : ss) {
            result = result + s + sep;
        }
        return result;
    }

    private String collapseStringArray(String[] ss) {
        return this.collapseStringArray(ss, "\n");
    }
}

