% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classifier.R
\name{topk}
\alias{topk}
\title{top-k accuracy indicator}
\usage{
topk(prob, observed, k)
}
\arguments{
\item{prob}{Numeric matrix of predicted probabilities (observations x classes).
Column names must correspond to class labels.}

\item{observed}{Factor or vector of observed class labels. Must be present in \code{colnames(prob)}.}

\item{k}{Integer; the number of top probabilities to consider.}
}
\value{
A \code{data.frame} with columns \code{topk} (logical indicator: \code{TRUE} if observed class is in top-k) and \code{observed}.
}
\description{
Determines if the true class label is among the top \code{k} predicted probabilities for each observation.
}
\examples{
probs <- matrix(c(0.1, 0.9, 0.8, 0.2, 0.3, 0.7), 3, 2, byrow=TRUE,
                dimnames = list(NULL, c("A", "B")))
obs <- factor(c("B", "A", "B"))
topk(probs, obs, k=1)
topk(probs, obs, k=2)
}
\seealso{
Other classifier evaluation: 
\code{\link{rank_score}()}
}
\concept{classifier evaluation}
