% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regress.R
\name{partial_inverse_projection.regress}
\alias{partial_inverse_projection.regress}
\title{Partial Inverse Projection for a \code{regress} Object}
\usage{
\method{partial_inverse_projection}{regress}(x, colind, ...)
}
\arguments{
\item{x}{A \code{regress} object (created by \code{\link{regress}}).}

\item{colind}{A numeric vector specifying which columns of the \emph{factor space}
(i.e., the second dimension of \code{x$coefficients}) you want to invert.
Typically these refer to a subset of canonical / PCA / PLS components.}

\item{...}{Further arguments passed to or used by methods (not used here).}
}
\value{
A matrix of shape \code{(length(colind) x nrow(x$coefficients))}. When
multiplied by partial factor scores \code{(n x length(colind))}, it yields
an \code{(n x nrow(x$coefficients))} reconstruction in the original domain.
}
\description{
This function computes a sub-block inversion of the regression coefficients,
allowing you to focus on only certain columns (e.g. partial factors).
If your coefficient matrix is not orthonormal or is not square, we use a
pseudoinverse approach (via \code{corpcor::pseudoinverse}) to find a minimal-norm
solution.
}
