% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.R
\name{measure_reconstruction_error}
\alias{measure_reconstruction_error}
\title{Compute reconstruction-based error metrics}
\usage{
measure_reconstruction_error(
  Xtrue,
  Xrec,
  metrics = c("mse", "rmse", "r2"),
  by_column = FALSE
)
}
\arguments{
\item{Xtrue}{Original data matrix, shape (n x p).}

\item{Xrec}{Reconstructed data matrix, shape (n x p).}

\item{metrics}{Character vector of metric names, e.g. \code{c("mse","rmse","r2","mae")}.}

\item{by_column}{Logical, if TRUE calculate R2 metric per column and average (default: FALSE).}
}
\value{
A one-row \code{tibble} with columns matching \code{metrics}.
}
\description{
Given two numeric matrices \code{Xtrue} and \code{Xrec}, compute:
\itemize{
\item MSE  (\code{"mse"})
\item RMSE (\code{"rmse"})
\item R^2  (\code{"r2"})
\item MAE  (\code{"mae"})
}
}
