% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\name{biplot.pca}
\alias{biplot.pca}
\title{Biplot for PCA Objects (Enhanced with ggrepel)}
\usage{
\method{biplot}{pca}(
  x,
  y = NULL,
  dims = c(1, 2),
  scale_arrows = 2,
  alpha_points = 0.6,
  point_size = 2,
  point_labels = NULL,
  var_labels = NULL,
  arrow_color = "red",
  text_color = "red",
  repel_points = TRUE,
  repel_vars = FALSE,
  ...
)
}
\arguments{
\item{x}{A \code{pca} object returned by \code{\link{pca}}.}

\item{y}{(ignored) Placeholder to match \code{biplot(x, y, ...)} signature.}

\item{dims}{A length-2 integer vector specifying which principal components to plot
on the x and y axes. Defaults to \code{c(1, 2)}.}

\item{scale_arrows}{A numeric factor to scale the variable loadings (arrows). Default is 2.}

\item{alpha_points}{Transparency level for the sample points. Default is 0.6.}

\item{point_size}{Size for the sample points. Default is 2.}

\item{point_labels}{Optional character vector of labels for the sample points.
If \code{NULL}, rownames of the scores matrix are used if available; otherwise numeric indices.}

\item{var_labels}{Optional character vector of variable names (columns in the original data).
If \code{NULL}, rownames of \code{x\$v} are used if available; otherwise "Var1", "Var2", etc.}

\item{arrow_color}{Color for the loading arrows. Default is "red".}

\item{text_color}{Color for the variable label text. Default is "red".}

\item{repel_points}{Logical; if TRUE, repel sample labels using \code{geom_text_repel}. Default is \code{TRUE}.}

\item{repel_vars}{Logical; if TRUE, repel variable labels using \code{geom_text_repel}. Default is \code{FALSE}.}

\item{...}{Additional arguments passed on to \code{ggplot2} or \code{ggrepel} functions (if needed).}
}
\value{
A \code{ggplot} object.
}
\description{
Creates a 2D biplot for a \code{pca} object, using \pkg{ggplot2} and \pkg{ggrepel}
to show both sample scores (observations) and variable loadings (arrows).
}
\details{
This function constructs a scatterplot of the PCA scores (observations) on two chosen components
and overlays arrows for the loadings (variables). The arrow length and direction indicate how each
variable contributes to those principal components. You can control arrow scaling with \code{scale_arrows}.

If your \code{pca} object includes an \code{$explained_variance} field (e.g., proportion of variance per component),
those values will appear in the axis labels. Otherwise, the axes are labeled simply as "PC1", "PC2", etc.

\strong{Note}: If you do not have \pkg{ggrepel} installed, you can set \code{repel_points=FALSE} and
\code{repel_vars=FALSE}, or install \pkg{ggrepel}.
}
\examples{
\donttest{
data(iris)
X <- as.matrix(iris[,1:4])
pca_res <- pca(X, ncomp=2)

# Enhanced biplot with repelled text
biplot(pca_res, repel_points=TRUE, repel_vars=TRUE)
}
}
