% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariance-functions.R
\name{pearson.pvalue.unif}
\alias{pearson.pvalue.unif}
\title{compute the p-value by Pearson's approximation assuming uniform marginals and euclidean distance}
\usage{
pearson.pvalue.unif(
  x,
  vec = NA,
  type = "total",
  psi = NULL,
  isotropic = TRUE,
  ...
)
}
\description{
compute the p-value by Pearson's approximation assuming uniform marginals and euclidean distance
}
\examples{
multivariance:::pearson.pvalue.unif(matrix(runif(300),ncol = 3))

\dontrun{
library(microbenchmark)
x = matrix(runif(300*3),ncol = 3)
microbenchmark(
  multivariance.test(x,p.value.type = "pearson_approx")$p.value,
  multivariance:::pearson.pvalue.unif(emp.transf(x))
  )
}

}
\keyword{internal}
