% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariance-functions.R
\name{layout_on_circles}
\alias{layout_on_circles}
\title{special igraph layout for the dependence structure visualization}
\usage{
layout_on_circles(g, n = sum(is.na(igraph::V(g)$level)))
}
\arguments{
\item{g}{graph}

\item{n}{number of vertices on outer circle}
}
\description{
It places the variable nodes on an outer circle and the dependency nodes on an inner circle
}
\details{
This is the standard layout for the full dependence structure, since in this case there often too many nodes which make the other (usual) layout incomprehensible.
}
\examples{
N = 200
y = coins(N,2)
x = cbind(y,y,y)

g = dependence.structure(x,structure.type = "clustered",verbose = FALSE)$graph
plot(g)
plot(g,layout = layout_on_circles(g))
}
