# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' fast Euclidean distance matrix
#'
#' @param x matrix with sample rows for which the distance matrix is computed (to use with vectors, use \code{as.matrix(x)})
#' @examples
#' #require(microbenchmark)
#' #x = rnorm(100)
#' #microbenchmark(fastdist(as.matrix(x)),as.matrix(dist(x)))
#' @export
fastdist <- function(x) {
    .Call('_multivariance_fastdist', PACKAGE = 'multivariance', x)
}

#' double center a symmetric matrix
#'
#' @param x symmetric matrix
#' @param normalize boolean. If \code{TRUE} the matrix will be normalized to mean 1.
#' @keywords internal
doubleCenterSymMat <- function(x, normalize) {
    .Call('_multivariance_doubleCenterSymMat', PACKAGE = 'multivariance', x, normalize)
}

#' fast centered Euclidean distance matrix
#'
#' @param x matrix with sample rows for which the distance matrix is computed (to use with vectors, use \code{as.matrix(x)})
#' @param normalize boolean. If \code{TRUE} the matrix will be normalized to mean 1.
#' @export
fastEuclideanCdm <- function(x, normalize) {
    .Call('_multivariance_fastEuclideanCdm', PACKAGE = 'multivariance', x, normalize)
}

#' for the fast detection of the full dependence structure
#'
#' Returns the row indicies of matrix A which match with B
#'
#' @param A matrix
#' @param B matrix whose rows are subset of A
#'
#' @examples
#' # A = t(utils::combn(10,3))
#' # B = A[sort(sample.int(nrow(A),10)),]
#' # match_rows(A,B)
#'
#' @keywords internal
match_rows <- function(A, B) {
    .Call('_multivariance_match_rows', PACKAGE = 'multivariance', A, B)
}

