\name{dealWithLabelSwitching}
\alias{dealWithLabelSwitching}
\title{
Post-process the generated MCMC sample in order to undo possible label switching. 
}
\description{
This function implements the Equivalence Classes Representatives (ECR) algorithm from the label.switching package in order to undo the label switching phenomenon.
}
\usage{
dealWithLabelSwitching(gs, burn, thin = 10, zPivot = NULL, returnRaw = FALSE, maxM = NULL)
}
\arguments{
  \item{gs}{
An object generated by the main function of the package. 
}
  \item{burn}{
Number of draws that will be discarder as burn-in.
}
  \item{thin}{
Thinning of the MCMC sample.
}
  \item{zPivot}{
Optional vector of allocations that will be used as the pivot of the ECR algorithm. If this is not supplied, the pivot will be selected as the allocation vector that corresponds to the iteration that maximized the log-likelihood of the model.
}
  \item{returnRaw}{
Boolean. If true, the function will also return the raw output. 
}
  \item{maxM}{
Not used.
}
}
\details{
See Papastamoulis (2016).
}
\value{
\item{cluster}{Single best clustering of the data, according to the Maximum A Posteriori rule.}
\item{nClusters_posterior}{Estimated posterior distribution of the number of clusters.}
\item{mcmc}{Post-processed mcmc output.}
\item{posteriorProbabilities}{Estimated posterior membership probabilities.}
}
\references{
Papastamoulis, P. (2016). \code{label.switching}: An R Package for Dealing with the Label Switching Problem in MCMC Outputs. Journal of Statistical Software, 69(1), 1-24.
}
\author{
Panagiotis Papastamoulis
}

